
    create table EventTypes (
        InstanceId bigint not null,
        element varchar(255)
    );

    create table ProcessInstanceEventInfo (
        id bigint generated by default as identity,
        eventType varchar(255),
        processInstanceId bigint not null,
        OPTLOCK integer,
        primary key (id)
    );

    create table ProcessInstanceInfo (
        InstanceId bigint generated by default as identity,
        OPTLOCK integer,
        processId varchar(255),
        startDate timestamp,
        lastReadDate timestamp,
        lastModificationDate timestamp,
        state integer not null,
        processInstanceByteArray blob,
        primary key (InstanceId)
    );

    create table SessionInfo (
        id integer generated by default as identity,
        lastModificationDate timestamp,
        rulesByteArray blob,
        startDate timestamp,
        OPTLOCK integer,
        primary key (id)
    );

    create table WorkItemInfo (
        workItemId bigint generated by default as identity,
        creationDate timestamp,
        name varchar(255),
        processInstanceId bigint not null,
        state bigint not null,
        OPTLOCK integer,
        workItemByteArray blob,
        primary key (workItemId)
    );

    alter table EventTypes 
        add constraint FKB0E5621F7665489A 
        foreign key (InstanceId) 
        references ProcessInstanceInfo;
