/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.BitronixTransactionSynchronizationRegistry;
import bitronix.tm.Configuration;
import bitronix.tm.journal.DiskJournal;
import bitronix.tm.journal.Journal;
import bitronix.tm.journal.NullJournal;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.resource.ResourceLoader;
import bitronix.tm.timer.TaskScheduler;
import bitronix.tm.twopc.executor.BackportConcurrentExecutor;
import bitronix.tm.twopc.executor.ConcurrentExecutor;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.SimpleAsyncExecutor;
import bitronix.tm.twopc.executor.SyncExecutor;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManagerServices {
    private static final Logger log = LoggerFactory.getLogger(TransactionManagerServices.class);
    private static BitronixTransactionManager transactionManager;
    private static BitronixTransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static Configuration configuration;
    private static Journal journal;
    private static TaskScheduler taskScheduler;
    private static ResourceLoader resourceLoader;
    private static Recoverer recoverer;
    private static Executor executor;

    public static synchronized BitronixTransactionManager getTransactionManager() {
        if (transactionManager == null) {
            transactionManager = new BitronixTransactionManager();
        }
        return transactionManager;
    }

    public static synchronized BitronixTransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        if (transactionSynchronizationRegistry == null) {
            transactionSynchronizationRegistry = new BitronixTransactionSynchronizationRegistry();
        }
        return transactionSynchronizationRegistry;
    }

    public static synchronized Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new Configuration();
        }
        return configuration;
    }

    public static synchronized Journal getJournal() {
        if (journal == null) {
            String configuredJounal = TransactionManagerServices.getConfiguration().getJournal();
            if ("disk".equals(configuredJounal)) {
                journal = new DiskJournal();
            } else if ("null".equals(configuredJounal)) {
                journal = new NullJournal();
            } else {
                try {
                    Class clazz = ClassLoaderUtils.loadClass(configuredJounal);
                    journal = (Journal)clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new InitializationException("invalid journal implementation '" + configuredJounal + "'", ex);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("using journal " + configuredJounal);
            }
        }
        return journal;
    }

    public static synchronized TaskScheduler getTaskScheduler() {
        if (taskScheduler == null) {
            taskScheduler = new TaskScheduler();
            taskScheduler.start();
        }
        return taskScheduler;
    }

    public static synchronized ResourceLoader getResourceLoader() {
        if (resourceLoader == null) {
            resourceLoader = new ResourceLoader();
        }
        return resourceLoader;
    }

    public static synchronized Recoverer getRecoverer() {
        if (recoverer == null) {
            recoverer = new Recoverer();
        }
        return recoverer;
    }

    public static synchronized Executor getExecutor() {
        if (executor == null) {
            boolean async = TransactionManagerServices.getConfiguration().isAsynchronous2Pc();
            if (async) {
                if (log.isDebugEnabled()) {
                    log.debug("trying to use ConcurrentExecutor");
                }
                if (!(executor = new ConcurrentExecutor()).isUsable()) {
                    if (log.isDebugEnabled()) {
                        log.debug("trying to use BackportConcurrentExecutor");
                    }
                    executor = new BackportConcurrentExecutor();
                }
                if (!executor.isUsable()) {
                    if (log.isDebugEnabled()) {
                        log.debug("using SimpleAsyncExecutor");
                    }
                    executor = new SimpleAsyncExecutor();
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("using SyncExecutor");
                }
                executor = new SyncExecutor();
            }
        }
        return executor;
    }

    public static synchronized boolean isTransactionManagerRunning() {
        return transactionManager != null;
    }

    public static synchronized boolean isTaskSchedulerRunning() {
        return taskScheduler != null;
    }

    protected static synchronized void clear() {
        transactionManager = null;
        transactionSynchronizationRegistry = null;
        configuration = null;
        journal = null;
        taskScheduler = null;
        resourceLoader = null;
        recoverer = null;
        executor = null;
    }
}

