/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.utils.Decoder;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogHeader {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogHeader.class);
    public static final int FORMAT_ID_HEADER = 0;
    public static final int TIMESTAMP_HEADER = 4;
    public static final int STATE_HEADER = 12;
    public static final int CURRENT_POSITION_HEADER = 13;
    public static final int HEADER_LENGTH = 21;
    public static final byte CLEAN_LOG_STATE = 0;
    public static final byte UNCLEAN_LOG_STATE = -1;
    private final RandomAccessFile randomAccessFile;
    private int formatId;
    private long timestamp;
    private byte state;
    private long position;
    private long maxFileLength;

    public TransactionLogHeader(RandomAccessFile randomAccessFile, long maxFileLength) throws IOException {
        this.randomAccessFile = randomAccessFile;
        this.maxFileLength = maxFileLength;
        randomAccessFile.seek(0L);
        this.formatId = randomAccessFile.readInt();
        this.timestamp = randomAccessFile.readLong();
        this.state = randomAccessFile.readByte();
        this.position = randomAccessFile.readLong();
        randomAccessFile.seek(this.position);
        if (log.isDebugEnabled()) {
            log.debug("read header " + this);
        }
    }

    public int getFormatId() {
        return this.formatId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getState() {
        return this.state;
    }

    public long getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormatId(int formatId) throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            long currentPos = this.randomAccessFile.getFilePointer();
            this.randomAccessFile.seek(0L);
            this.randomAccessFile.writeInt(formatId);
            this.randomAccessFile.seek(currentPos);
        }
        this.formatId = formatId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(long timestamp) throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            long currentPos = this.randomAccessFile.getFilePointer();
            this.randomAccessFile.seek(4L);
            this.randomAccessFile.writeLong(timestamp);
            this.randomAccessFile.seek(currentPos);
        }
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte state) throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            long currentPos = this.randomAccessFile.getFilePointer();
            this.randomAccessFile.seek(12L);
            this.randomAccessFile.writeByte(state);
            this.randomAccessFile.seek(currentPos);
        }
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(long position) throws IOException {
        if (position < 21L) {
            throw new IOException("invalid position " + position + " (too low)");
        }
        if (position >= this.maxFileLength) {
            throw new IOException("invalid position " + position + " (too high)");
        }
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            this.randomAccessFile.seek(13L);
            this.randomAccessFile.writeLong(position);
            this.randomAccessFile.seek(position);
        }
        this.position = position;
    }

    public void goAhead(long distance) throws IOException {
        this.setPosition(this.getPosition() + distance);
    }

    public void rewind() throws IOException {
        this.setPosition(21L);
    }

    public String toString() {
        return "a Bitronix TransactionLogHeader with timestamp=" + this.timestamp + ", state=" + Decoder.decodeHeaderState(this.state) + ", position=" + this.position;
    }
}

