/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.internal.BitronixHeuristicMixedException;
import bitronix.tm.internal.BitronixHeuristicRollbackException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.AbstractPhaseEngine;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Committer
extends AbstractPhaseEngine {
    private static final Logger log = LoggerFactory.getLogger(Committer.class);
    private boolean onePhase;
    private List interestedResources;
    private final List committedResources = Collections.synchronizedList(new ArrayList());

    public Committer(Executor executor) {
        super(executor);
    }

    public void commit(BitronixTransaction transaction, List interestedResources) throws HeuristicMixedException, HeuristicRollbackException, BitronixSystemException {
        XAResourceManager resourceManager = transaction.getResourceManager();
        if (resourceManager.size() == 0) {
            transaction.setStatus(8);
            transaction.setStatus(3);
            if (log.isDebugEnabled()) {
                log.debug("phase 2 commit succeeded with no interested resource");
            }
            return;
        }
        transaction.setStatus(8);
        this.interestedResources = Collections.unmodifiableList(interestedResources);
        this.onePhase = resourceManager.size() == 1;
        try {
            this.executePhase(resourceManager, true);
        }
        catch (PhaseException ex) {
            this.logFailedResources(ex);
            transaction.setStatus(5);
            this.throwException("transaction failed during commit of " + transaction, ex, interestedResources.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("phase 2 commit executed on resources " + Decoder.collectResourcesNames(this.committedResources));
        }
        ArrayList committedAndNotInterestedUniqueNames = new ArrayList();
        committedAndNotInterestedUniqueNames.addAll(Committer.collectResourcesUniqueNames(this.committedResources));
        List notInterestedResources = Committer.collectNotInterestedResources(resourceManager.getAllResources(), interestedResources);
        committedAndNotInterestedUniqueNames.addAll(Committer.collectResourcesUniqueNames(notInterestedResources));
        if (log.isDebugEnabled()) {
            ArrayList committedAndNotInterestedResources = new ArrayList();
            committedAndNotInterestedResources.addAll(this.committedResources);
            committedAndNotInterestedResources.addAll(notInterestedResources);
            log.debug("phase 2 commit succeeded on resources " + Decoder.collectResourcesNames(committedAndNotInterestedResources));
        }
        transaction.setStatus(3, new HashSet(committedAndNotInterestedUniqueNames));
    }

    private void throwException(String message, PhaseException phaseException, int totalResourceCount) throws HeuristicMixedException, HeuristicRollbackException {
        List exceptions = phaseException.getExceptions();
        List resources = phaseException.getResourceStates();
        boolean hazard = false;
        ArrayList<XAResourceHolderState> heuristicResources = new ArrayList<XAResourceHolderState>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception ex = (Exception)exceptions.get(i);
            XAResourceHolderState resourceHolder = (XAResourceHolderState)resources.get(i);
            if (ex instanceof XAException) {
                XAException xaEx = (XAException)ex;
                switch (xaEx.errorCode) {
                    case 8: {
                        hazard = true;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        heuristicResources.add(resourceHolder);
                        break;
                    }
                    default: {
                        errorResources.add(resourceHolder);
                        break;
                    }
                }
                continue;
            }
            errorResources.add(resourceHolder);
        }
        if (!hazard && heuristicResources.size() == totalResourceCount) {
            throw new BitronixHeuristicRollbackException(message + ":" + " all resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally rolled back", phaseException);
        }
        throw new BitronixHeuristicMixedException(message + ":" + (errorResources.size() > 0 ? " resource(s) " + Decoder.collectResourcesNames(errorResources) + " threw unexpected exception" : "") + (errorResources.size() > 0 && heuristicResources.size() > 0 ? " and" : "") + (heuristicResources.size() > 0 ? " resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally rolled back" + (hazard ? " (or hazard happened)" : "") : ""), phaseException);
    }

    protected Job createJob(XAResourceHolderState resourceHolder) {
        return new CommitJob(resourceHolder);
    }

    protected boolean isParticipating(XAResourceHolderState xaResourceHolderState) {
        for (int i = 0; i < this.interestedResources.size(); ++i) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)this.interestedResources.get(i);
            if (xaResourceHolderState != resourceHolderState) continue;
            return true;
        }
        return false;
    }

    private class CommitJob
    extends Job {
        public CommitJob(XAResourceHolderState resourceHolder) {
            super(resourceHolder);
        }

        public XAException getXAException() {
            return this.xaException;
        }

        public RuntimeException getRuntimeException() {
            return this.runtimeException;
        }

        public void execute() {
            try {
                this.commitResource(this.getResource(), Committer.this.onePhase);
            }
            catch (RuntimeException ex) {
                this.runtimeException = ex;
            }
            catch (XAException ex) {
                this.xaException = ex;
            }
        }

        private void commitResource(XAResourceHolderState resourceHolder, boolean onePhase) throws XAException {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("committing resource " + resourceHolder + (onePhase ? " (with one-phase optimization)" : ""));
                }
                resourceHolder.getXAResource().commit(resourceHolder.getXid(), onePhase);
                Committer.this.committedResources.add(resourceHolder);
                if (log.isDebugEnabled()) {
                    log.debug("committed resource " + resourceHolder);
                }
            }
            catch (XAException ex) {
                this.handleXAException(resourceHolder, ex);
            }
        }

        private void handleXAException(XAResourceHolderState failedResourceHolder, XAException xaException) throws XAException {
            switch (xaException.errorCode) {
                case 7: {
                    this.forgetHeuristicCommit(failedResourceHolder);
                    return;
                }
                case -4: {
                    throw new BitronixXAException("unknown heuristic termination, global state of this transaction is unknown - guilty: " + failedResourceHolder, 8, xaException);
                }
                case 5: 
                case 6: 
                case 8: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    log.error("heuristic rollback is incompatible with the global state of this transaction - guilty: " + failedResourceHolder);
                    throw xaException;
                }
            }
            log.warn("resource '" + failedResourceHolder.getUniqueName() + "' reported " + Decoder.decodeXAExceptionErrorCode(xaException) + " when asked to commit transaction branch. Transaction is prepared and will commit via recovery service when resource availability allows.", (Throwable)xaException);
        }

        private void forgetHeuristicCommit(XAResourceHolderState resourceHolder) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("handling heuristic commit on resource " + resourceHolder.getXAResource());
                }
                resourceHolder.getXAResource().forget(resourceHolder.getXid());
                if (log.isDebugEnabled()) {
                    log.debug("forgotten heuristically committed resource " + resourceHolder.getXAResource());
                }
            }
            catch (XAException ex) {
                log.error("cannot forget " + resourceHolder.getXid() + " assigned to " + resourceHolder.getXAResource() + ", error=" + Decoder.decodeXAExceptionErrorCode(ex), (Throwable)ex);
            }
        }

        public String toString() {
            return "a CommitJob " + (Committer.this.onePhase ? "(one phase) " : "") + "with " + this.getResource();
        }
    }
}

