/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.ChangeSet;
import org.drools.agent.KnowledgeAgent;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.event.knowledgeagent.AfterChangeSetAppliedEvent;
import org.drools.event.knowledgeagent.AfterChangeSetProcessedEvent;
import org.drools.event.knowledgeagent.AfterResourceProcessedEvent;
import org.drools.event.knowledgeagent.BeforeChangeSetAppliedEvent;
import org.drools.event.knowledgeagent.BeforeChangeSetProcessedEvent;
import org.drools.event.knowledgeagent.BeforeResourceProcessedEvent;
import org.drools.event.knowledgeagent.KnowledgeAgentEventListener;
import org.drools.event.knowledgeagent.KnowledgeBaseUpdatedEvent;
import org.drools.event.knowledgeagent.ResourceCompilationFailedEvent;
import org.drools.io.Resource;
import org.drools.io.impl.ChangeSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetHelperImpl {
    private ChangeSetImpl changeSet = new ChangeSetImpl();

    public void addNewResource(Resource resource) {
        this.changeSet.setResourcesAdded(this.addResourceToCollection(this.changeSet.getResourcesAdded(), resource));
    }

    public void addModifiedResource(Resource resource) {
        this.changeSet.setResourcesModified(this.addResourceToCollection(this.changeSet.getResourcesModified(), resource));
    }

    public void addRemovedResource(Resource resource) {
        this.changeSet.setResourcesRemoved(this.addResourceToCollection(this.changeSet.getResourcesRemoved(), resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangeSet(KnowledgeAgent kagent) {
        if (this.changeSet.isEmpty()) {
            return;
        }
        MyKnowledgeAgentEventListener kagentEventListener = new MyKnowledgeAgentEventListener();
        try {
            kagent.addEventListener((KnowledgeAgentEventListener)kagentEventListener);
            kagent.applyChangeSet((ChangeSet)this.changeSet);
            if (kagentEventListener.hasCompilationErrors()) {
                throw new RuntimeException(kagentEventListener.getCompilationErrorsMessage());
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            kagent.removeEventListener((KnowledgeAgentEventListener)kagentEventListener);
            throw throwable;
        }
        kagent.removeEventListener((KnowledgeAgentEventListener)kagentEventListener);
        this.reset();
    }

    public void reset() {
        this.changeSet = new ChangeSetImpl();
    }

    public ChangeSetImpl getChangeSet() {
        return this.changeSet;
    }

    private Collection<Resource> addResourceToCollection(Collection<Resource> resources, Resource resource) {
        ArrayList<Resource> newCollection = new ArrayList<Resource>();
        if (resources != null) {
            newCollection.addAll(resources);
        }
        newCollection.add(resource);
        return newCollection;
    }

    private class MyKnowledgeAgentEventListener
    implements KnowledgeAgentEventListener {
        private List<KnowledgeBuilderErrors> compilationErrors = new ArrayList<KnowledgeBuilderErrors>();

        private MyKnowledgeAgentEventListener() {
        }

        public void beforeChangeSetApplied(BeforeChangeSetAppliedEvent event) {
        }

        public void afterChangeSetApplied(AfterChangeSetAppliedEvent event) {
        }

        public void beforeChangeSetProcessed(BeforeChangeSetProcessedEvent event) {
        }

        public void afterChangeSetProcessed(AfterChangeSetProcessedEvent event) {
        }

        public void beforeResourceProcessed(BeforeResourceProcessedEvent event) {
        }

        public void afterResourceProcessed(AfterResourceProcessedEvent event) {
        }

        public void knowledgeBaseUpdated(KnowledgeBaseUpdatedEvent event) {
        }

        public void resourceCompilationFailed(ResourceCompilationFailedEvent event) {
            this.compilationErrors.add(event.getKnowledgeBuilder().getErrors());
        }

        public boolean hasCompilationErrors() {
            return !this.compilationErrors.isEmpty();
        }

        public String getCompilationErrorsMessage() {
            StringBuilder message = new StringBuilder("");
            if (this.hasCompilationErrors()) {
                for (KnowledgeBuilderErrors knowledgeBuilderErrors : this.compilationErrors) {
                    for (KnowledgeBuilderError error : knowledgeBuilderErrors) {
                        message.append("Compilation error: ");
                        message.append(error.getMessage());
                        message.append("\n");
                    }
                }
            }
            return message.toString();
        }
    }
}

