/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.kproject.KBase;
import org.drools.kproject.KBaseImpl;
import org.drools.kproject.KProject;
import org.drools.kproject.KProjectImpl;
import org.drools.kproject.KSession;
import org.drools.kproject.KSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KProjectChangeLog
implements PropertyChangeListener {
    private boolean kProjectDirty;
    private Set<String> addedKBases;
    private Set<String> removedKBases;
    private Set<String> removedKSessions;
    private Set<String> addedKSessions;
    private Map<String, KSession> kSessions;
    private Map<String, KBase> kBases;

    public KProjectChangeLog() {
        this.reset();
    }

    public boolean isKProjectDirty() {
        return this.kProjectDirty;
    }

    public void setKProjectDirty(boolean kProjectDirty) {
        this.kProjectDirty = kProjectDirty;
    }

    public boolean iskProjectDirty() {
        return this.kProjectDirty;
    }

    public void setkProjectDirty(boolean kProjectDirty) {
        this.kProjectDirty = kProjectDirty;
    }

    public Set<String> getAddedKBases() {
        return this.addedKBases;
    }

    public void setAddedKBases(Set<String> addedKBases) {
        this.addedKBases = addedKBases;
    }

    public Set<String> getRemovedKBases() {
        return this.removedKBases;
    }

    public void setRemovedKBases(Set<String> removedKBases) {
        this.removedKBases = removedKBases;
    }

    public Set<String> getRemovedKSessions() {
        return this.removedKSessions;
    }

    public void setRemovedKSessions(Set<String> removedKSessions) {
        this.removedKSessions = removedKSessions;
    }

    public Set<String> getAddedKSessions() {
        return this.addedKSessions;
    }

    public void setAddedKSessions(Set<String> addedKSessions) {
        this.addedKSessions = addedKSessions;
    }

    public Map<String, KSession> getKSessions() {
        return this.kSessions;
    }

    public void setKSessions(Map<String, KSession> kSessions) {
        this.kSessions = kSessions;
    }

    public Map<String, KBase> getKBases() {
        return this.kBases;
    }

    public void setKBases(Map<String, KBase> kBases) {
        this.kBases = kBases;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof KProjectImpl) {
            KProject kProject = (KProject)evt.getSource();
            if ("kBases".equals(evt.getPropertyName())) {
                Map oldKBases = (Map)evt.getOldValue();
                Map newKBases = (Map)evt.getNewValue();
                if (oldKBases.size() < newKBases.size()) {
                    for (Map.Entry entry : newKBases.entrySet()) {
                        if (oldKBases.containsKey(entry.getKey())) continue;
                        this.removedKBases.remove(entry.getKey());
                        this.addedKBases.add((String)entry.getKey());
                        this.kBases.put((String)entry.getKey(), (KBase)newKBases.get(entry.getKey()));
                        return;
                    }
                    throw new IllegalStateException("Maps are different sizes, yet we can't find the new KBase");
                }
                if (oldKBases.size() > newKBases.size()) {
                    for (Map.Entry entry : oldKBases.entrySet()) {
                        if (newKBases.containsKey(entry.getKey())) continue;
                        this.addedKBases.remove(entry.getKey());
                        this.removedKBases.add((String)entry.getKey());
                        this.kBases.put((String)entry.getKey(), (KBase)oldKBases.get(entry.getKey()));
                        return;
                    }
                    throw new IllegalStateException("Maps are different sizes, yet we can't find the removed KBase");
                }
            } else {
                this.kProjectDirty = true;
            }
        } else if (evt.getSource() instanceof KBaseImpl) {
            KBaseImpl kBase = (KBaseImpl)evt.getSource();
            if ("kSessions".equals(evt.getPropertyName())) {
                Map oldKSession = (Map)evt.getOldValue();
                Map newKSession = (Map)evt.getNewValue();
                if (oldKSession.size() < newKSession.size()) {
                    for (Map.Entry entry : newKSession.entrySet()) {
                        if (oldKSession.containsKey(entry.getKey())) continue;
                        this.removedKSessions.remove(entry.getKey());
                        this.addedKSessions.add((String)entry.getKey());
                        this.kSessions.put((String)entry.getKey(), (KSession)newKSession.get(entry.getKey()));
                        return;
                    }
                    throw new IllegalStateException("Maps are different sizes, yet we can't find the new KBase");
                }
                if (oldKSession.size() > newKSession.size()) {
                    for (Map.Entry entry : oldKSession.entrySet()) {
                        if (newKSession.containsKey(entry.getKey())) continue;
                        this.addedKSessions.remove(entry.getKey());
                        this.removedKSessions.add((String)entry.getKey());
                        this.kSessions.put((String)entry.getKey(), (KSession)oldKSession.get(entry.getKey()));
                        return;
                    }
                    throw new IllegalStateException("Maps are different sizes, yet we can't find the removed KBase");
                }
            } else if ("namespace".equals(evt.getPropertyName())) {
                String oldV = (String)evt.getOldValue();
                String newV = (String)evt.getNewValue();
                String oldQName = oldV + "." + kBase.getName();
                String newQName = newV + "." + kBase.getName();
                kBase.getKProject().moveKBase(oldQName, newQName);
                this.removedKBases.remove(newQName);
                this.removedKBases.add(oldQName);
                this.addedKBases.remove(oldQName);
                this.addedKBases.add(newQName);
                this.kBases.put(newQName, kBase);
            } else if ("name".equals(evt.getPropertyName())) {
                String oldV = (String)evt.getOldValue();
                String newV = (String)evt.getNewValue();
                String oldQName = kBase.getNamespace() + "." + oldV;
                String newQName = kBase.getNamespace() + "." + newV;
                kBase.getKProject().moveKBase(oldQName, newQName);
                this.removedKBases.remove(newQName);
                this.removedKBases.add(oldQName);
                this.addedKBases.remove(oldQName);
                this.addedKBases.add(newQName);
                this.kBases.put(newQName, kBase);
            } else {
                this.addedKBases.add(kBase.getQName());
            }
        } else if (evt.getSource() instanceof KSessionImpl) {
            KSessionImpl kSession = (KSessionImpl)evt.getSource();
            if ("namespace".equals(evt.getPropertyName())) {
                String oldV = (String)evt.getOldValue();
                String newV = (String)evt.getNewValue();
                String oldQName = oldV + "." + kSession.getName();
                String newQName = newV + "." + kSession.getName();
                kSession.getKBase().moveKSession(oldQName, newQName);
                this.removedKSessions.remove(newQName);
                this.removedKSessions.add(oldQName);
                this.addedKSessions.remove(oldQName);
                this.addedKSessions.add(newQName);
                this.kSessions.put(newQName, kSession);
            } else if ("name".equals(evt.getPropertyName())) {
                String oldV = (String)evt.getOldValue();
                String newV = (String)evt.getNewValue();
                String oldQName = kSession.getNamespace() + "." + oldV;
                String newQName = kSession.getNamespace() + "." + newV;
                kSession.getKBase().moveKSession(oldQName, newQName);
                this.removedKSessions.remove(newQName);
                this.removedKSessions.add(oldQName);
                this.addedKSessions.remove(oldQName);
                this.addedKSessions.add(newQName);
                this.kSessions.put(newQName, kSession);
            } else {
                this.addedKSessions.add(kSession.getQName());
                this.kSessions.put(kSession.getQName(), kSession);
            }
        }
    }

    public void reset() {
        this.kProjectDirty = false;
        this.removedKBases = new HashSet<String>();
        this.addedKBases = new HashSet<String>();
        this.removedKSessions = new HashSet<String>();
        this.addedKSessions = new HashSet<String>();
        this.kBases = new HashMap<String, KBase>();
        this.kSessions = new HashMap<String, KSession>();
    }
}

