/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.localtime;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.example.localtime.LocalTimeProtocol;

public class LocalTimeServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(LocalTimeServerHandler.class.getName());

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        LocalTimeProtocol.Locations locations = (LocalTimeProtocol.Locations)((Object)e.getMessage());
        long currentTime = System.currentTimeMillis();
        LocalTimeProtocol.LocalTimes.Builder builder = LocalTimeProtocol.LocalTimes.newBuilder();
        for (LocalTimeProtocol.Location l : locations.getLocationList()) {
            TimeZone tz = TimeZone.getTimeZone(LocalTimeServerHandler.toString(l.getContinent()) + '/' + l.getCity());
            Calendar calendar = Calendar.getInstance(tz);
            calendar.setTimeInMillis(currentTime);
            builder.addLocalTime(LocalTimeProtocol.LocalTime.newBuilder().setYear(calendar.get(1)).setMonth(calendar.get(2) + 1).setDayOfMonth(calendar.get(5)).setDayOfWeek(LocalTimeProtocol.DayOfWeek.valueOf(calendar.get(7))).setHour(calendar.get(11)).setMinute(calendar.get(12)).setSecond(calendar.get(13)).build());
        }
        e.getChannel().write((Object)builder.build());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }

    private static String toString(LocalTimeProtocol.Continent c) {
        return "" + c.name().charAt(0) + c.name().toLowerCase().substring(1);
    }
}

