/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldAccessor;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.common.AbstractRuleBase;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleStore;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassBuilderFactory;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitCoreWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitMapPropertyWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitMapProxyClassBuilderImpl;
import org.drools.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.factmodel.traits.TraitTriplePropertyWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitTripleProxyClassBuilderImpl;
import org.drools.factmodel.traits.Traitable;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.reteoo.ReteooComponentFactory;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.HierarchyEncoder;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitFactory<T extends Thing<K>, K extends TraitableBean>
implements Opcodes,
Externalizable {
    private VirtualPropertyMode mode = VirtualPropertyMode.TRIPLES;
    public static final String SUFFIX = "_Trait__Extension";
    private static final String pack = "org.drools.factmodel.traits.";
    private Map<String, Constructor> factoryCache = new HashMap<String, Constructor>();
    private Map<Class, Class<? extends CoreWrapper<?>>> wrapperCache = new HashMap();
    private transient AbstractRuleBase ruleBase;

    public static void setMode(VirtualPropertyMode newMode, KnowledgeBase kBase) {
        RuleBase ruleBase = ((KnowledgeBaseImpl)kBase).getRuleBase();
        ReteooComponentFactory rcf = ((AbstractRuleBase)ruleBase).getConfiguration().getComponentFactory();
        ClassBuilderFactory cbf = rcf.getClassBuilderFactory();
        rcf.getTraitFactory().mode = newMode;
        switch (newMode) {
            case MAP: {
                cbf.setPropertyWrapperBuilder(new TraitMapPropertyWrapperClassBuilderImpl());
                cbf.setTraitProxyBuilder(new TraitMapProxyClassBuilderImpl());
                break;
            }
            case TRIPLES: {
                cbf.setPropertyWrapperBuilder(new TraitTriplePropertyWrapperClassBuilderImpl());
                cbf.setTraitProxyBuilder(new TraitTripleProxyClassBuilderImpl());
                break;
            }
            default: {
                throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)newMode));
            }
        }
    }

    public static TraitFactory getTraitBuilderForKnowledgeBase(KnowledgeBase kb) {
        AbstractRuleBase arb = (AbstractRuleBase)((KnowledgeBaseImpl)kb).getRuleBase();
        return arb.getConfiguration().getComponentFactory().getTraitFactory();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.mode);
        out.writeObject(this.factoryCache);
        out.writeObject(this.wrapperCache);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mode = (VirtualPropertyMode)((Object)in.readObject());
        this.factoryCache = (Map)in.readObject();
        this.wrapperCache = (Map)in.readObject();
    }

    @Deprecated
    public T getProxy(K core, Class<?> trait) throws LogicalTypeInconsistencyException {
        return this.getProxy(core, trait, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getProxy(K core, Class<?> trait, boolean logical) throws LogicalTypeInconsistencyException {
        Constructor<T> konst;
        String traitName = trait.getName();
        if (core.hasTrait(traitName)) {
            return (T)core.getTrait(traitName);
        }
        String key = TraitFactory.getKey(core.getClass(), trait);
        Map<String, Constructor> map = this.factoryCache;
        synchronized (map) {
            konst = this.factoryCache.get(key);
            if (konst == null) {
                konst = this.cacheConstructor(key, core, trait);
            }
        }
        Thing proxy = null;
        HierarchyEncoder hier = this.ruleBase.getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
        try {
            switch (this.mode) {
                case MAP: {
                    proxy = (Thing)konst.newInstance(core, core._getDynamicProperties(), hier.getCode(trait.getName()), hier.getBottom(), logical);
                    break;
                }
                case TRIPLES: {
                    proxy = (Thing)konst.newInstance(core, this.ruleBase.getTripleStore(), this.getTripleFactory(), hier.getCode(trait.getName()), hier.getBottom(), logical);
                    break;
                }
                default: {
                    throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)this.mode));
                }
            }
            return (T)proxy;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        throw new LogicalTypeInconsistencyException("Could not apply trait " + trait + " to object " + core, trait, core.getClass());
    }

    public AbstractRuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(AbstractRuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    private Constructor<T> cacheConstructor(String key, K core, Class<?> trait) {
        Class<T> proxyClass = this.buildProxyClass(key, core, trait);
        if (proxyClass == null) {
            return null;
        }
        try {
            Constructor<T> konst;
            switch (this.mode) {
                case MAP: {
                    konst = proxyClass.getConstructor(core.getClass(), Map.class, BitSet.class, BitSet.class, Boolean.TYPE);
                    break;
                }
                case TRIPLES: {
                    konst = proxyClass.getConstructor(core.getClass(), TripleStore.class, TripleFactory.class, BitSet.class, BitSet.class, Boolean.TYPE);
                    break;
                }
                default: {
                    throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)this.mode));
                }
            }
            this.factoryCache.put(key, konst);
            return konst;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getProxyName(ClassDefinition trait, ClassDefinition core) {
        return TraitFactory.getKey(core.getDefinedClass(), trait.getDefinedClass()) + "_Proxy";
    }

    public static String getPropertyWrapperName(ClassDefinition trait, ClassDefinition core) {
        return TraitFactory.getKey(core.getDefinedClass(), trait.getDefinedClass()) + "_ProxyWrapper";
    }

    private static String getKey(Class core, Class trait) {
        return trait.getName() + "." + core.getName();
    }

    public static String getSoftFieldKey(String fieldName, Class fieldType, Class trait, Class core) {
        return fieldName;
    }

    private Class<T> buildProxyClass(String key, K core, Class<?> trait) {
        Class<?> coreKlass = core.getClass();
        ClassDefinition tdef = this.ruleBase.getTraitRegistry().getTrait(trait.getName());
        ClassDefinition cdef = this.ruleBase.getTraitRegistry().getTraitable(coreKlass.getName());
        if (tdef == null) {
            throw new RuntimeDroolsException("Unable to find Trait definition for class " + trait.getName() + ". It should have been DECLARED as a trait");
        }
        if (cdef == null) {
            throw new RuntimeDroolsException("Unable to find Core class definition for class " + coreKlass.getName() + ". It should have been DECLARED as a trait");
        }
        String proxyName = TraitFactory.getProxyName(tdef, cdef);
        String wrapperName = TraitFactory.getPropertyWrapperName(tdef, cdef);
        ReteooComponentFactory rcf = this.ruleBase.getConfiguration().getComponentFactory();
        TraitPropertyWrapperClassBuilder propWrapperBuilder = (TraitPropertyWrapperClassBuilder)rcf.getClassBuilderFactory().getPropertyWrapperBuilder();
        propWrapperBuilder.init(tdef, this.ruleBase.getTraitRegistry());
        try {
            byte[] propWrapper = propWrapperBuilder.buildClass(cdef);
            this.ruleBase.registerAndLoadTypeDefinition(wrapperName, propWrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TraitProxyClassBuilder proxyBuilder = (TraitProxyClassBuilder)rcf.getClassBuilderFactory().getTraitProxyBuilder();
        proxyBuilder.init(tdef, rcf.getBaseTraitProxyClass(), this.ruleBase.getTraitRegistry());
        try {
            byte[] proxy = proxyBuilder.buildClass(cdef);
            this.ruleBase.registerAndLoadTypeDefinition(proxyName, proxy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BitSet mask = this.ruleBase.getTraitRegistry().getFieldMask(trait.getName(), cdef.getDefinedClass().getName());
            Class proxyClass = this.ruleBase.getRootClassLoader().loadClass(proxyName, true);
            this.bindAccessors(proxyClass, tdef, cdef, mask);
            Class wrapperClass = this.ruleBase.getRootClassLoader().loadClass(wrapperName, true);
            this.bindCoreAccessors(wrapperClass, cdef);
            return proxyClass;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void bindAccessors(Class<T> proxyClass, ClassDefinition tdef, ClassDefinition cdef, BitSet mask) {
        int j = 0;
        for (FieldDefinition traitField : tdef.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(traitField, j++, mask);
            if (isSoftField) continue;
            String traitFieldHook = traitField.resolveAlias();
            FieldDefinition field = cdef.getFieldByAlias(traitFieldHook);
            try {
                if ((!cdef.isFullTraiting() || traitField.getType().isPrimitive() && !field.getType().equals(traitField.getType())) && !field.getType().isAssignableFrom(traitField.getType())) continue;
                Field staticField = proxyClass.getField(traitField.getName() + "_reader");
                staticField.set(null, field.getFieldAccessor().getReadAccessor());
                staticField = proxyClass.getField(traitField.getName() + "_writer");
                staticField.set(null, field.getFieldAccessor().getWriteAccessor());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindCoreAccessors(Class<T> wrapperClass, ClassDefinition cdef) {
        for (FieldDefinition field : cdef.getFieldsDefinitions()) {
            try {
                Field staticField = wrapperClass.getField(field.getName() + "_reader");
                staticField.set(null, field.getFieldAccessor().getReadAccessor());
                staticField = wrapperClass.getField(field.getName() + "_writer");
                staticField.set(null, field.getFieldAccessor().getWriteAccessor());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private Package getPackage(String pack) {
        Package pkg = this.ruleBase.getPackage(pack);
        if (pkg == null) {
            pkg = new Package(pack);
            JavaDialectRuntimeData data = new JavaDialectRuntimeData();
            pkg.getDialectRuntimeRegistry().setDialectData("java", data);
            data.onAdd(pkg.getDialectRuntimeRegistry(), this.ruleBase.getRootClassLoader());
            this.ruleBase.addPackages(Arrays.asList(pkg));
        }
        return pkg;
    }

    public synchronized CoreWrapper<K> getCoreWrapper(Class<K> coreKlazz, ClassDefinition coreDef) {
        if (this.wrapperCache == null) {
            this.wrapperCache = new HashMap();
        }
        Class<CoreWrapper<Object>> wrapperClass = null;
        if (this.wrapperCache.containsKey(coreKlazz)) {
            wrapperClass = this.wrapperCache.get(coreKlazz);
        } else {
            try {
                wrapperClass = this.buildCoreWrapper(coreKlazz, coreDef);
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.wrapperCache.put(coreKlazz, wrapperClass);
        }
        try {
            this.ruleBase.getTraitRegistry().addTraitable(this.buildWrapperClassDefinition(coreKlazz, wrapperClass));
            return wrapperClass != null ? wrapperClass.newInstance() : null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private ClassDefinition buildWrapperClassDefinition(Class<K> coreKlazz, Class<? extends CoreWrapper<K>> wrapperClass) throws IOException {
        ClassFieldInspector inspector = new ClassFieldInspector(coreKlazz);
        Package traitPackage = this.ruleBase.getPackagesMap().get(pack);
        if (traitPackage == null) {
            traitPackage = new Package(pack);
            traitPackage.setClassFieldAccessorCache(this.ruleBase.getClassFieldAccessorCache());
            this.ruleBase.getPackagesMap().put(pack, traitPackage);
        }
        ClassFieldAccessorStore store = traitPackage.getClassFieldAccessorStore();
        String className = coreKlazz.getName() + "Wrapper";
        String superClass = coreKlazz.getName();
        String[] interfaces = new String[]{CoreWrapper.class.getName()};
        ClassDefinition def = new ClassDefinition(className, superClass, interfaces);
        Traitable tbl = wrapperClass.getAnnotation(Traitable.class);
        def.setTraitable(true, tbl != null && tbl.logical());
        def.setDefinedClass(wrapperClass);
        Map<String, Field> fields = inspector.getFieldTypesField();
        for (Field f : fields.values()) {
            if (f == null) continue;
            FieldDefinition fld = new FieldDefinition();
            fld.setName(f.getName());
            fld.setTypeName(f.getType().getName());
            fld.setInherited(true);
            ClassFieldAccessor accessor = store.getAccessor(def.getDefinedClass().getName(), fld.getName());
            fld.setReadWriteAccessor(accessor);
            def.addField(fld);
        }
        return def;
    }

    private Class<CoreWrapper<K>> buildCoreWrapper(Class<K> coreKlazz, ClassDefinition coreDef) throws IOException, ClassNotFoundException {
        String coreName = coreKlazz.getName();
        String wrapperName = coreName + "Wrapper";
        try {
            byte[] wrapper = new TraitCoreWrapperClassBuilderImpl().buildClass(coreDef);
            this.ruleBase.registerAndLoadTypeDefinition(wrapperName, wrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class wrapperClass = this.ruleBase.getRootClassLoader().loadClass(wrapperName, true);
        return wrapperClass;
    }

    public static void valueOf(MethodVisitor mv, String type) {
        mv.visitMethodInsn(184, BuildUtils.getInternalType(BuildUtils.box(type)), "valueOf", "(" + BuildUtils.getTypeDescriptor(type) + ")" + BuildUtils.getTypeDescriptor(BuildUtils.box(type)));
    }

    public static void primitiveValue(MethodVisitor mv, String fieldType) {
        mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fieldType)));
        mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fieldType)), fieldType + "Value", "()" + BuildUtils.getTypeDescriptor(fieldType));
    }

    public static void invokeExtractor(MethodVisitor mv, String masterName, ClassDefinition trait, ClassDefinition core, FieldDefinition field) {
        String fieldType = field.getTypeName();
        mv.visitFieldInsn(178, BuildUtils.getInternalType(masterName), field.getName() + "_reader", Type.getDescriptor(InternalReadAccessor.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", BuildUtils.getTypeDescriptor(core.getClassName()));
        String returnType = BuildUtils.isPrimitive(fieldType) ? BuildUtils.getTypeDescriptor(fieldType) : Type.getDescriptor(Object.class);
        mv.visitMethodInsn(185, Type.getInternalName(InternalReadAccessor.class), BuildUtils.extractor(fieldType), Type.getMethodDescriptor((Type)Type.getType((String)returnType), (Type[])new Type[]{Type.getType(Object.class)}));
    }

    public static void invokeInjector(MethodVisitor mv, String masterName, ClassDefinition source, ClassDefinition target, FieldDefinition field, boolean toNull, int pointer) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        mv.visitFieldInsn(178, BuildUtils.getInternalType(masterName), fieldName + "_writer", "Lorg/drools/spi/WriteAccessor;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", BuildUtils.getTypeDescriptor(target.getName()));
        if (toNull) {
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
        } else {
            mv.visitVarInsn(BuildUtils.varType(fieldType), pointer);
        }
        String argType = BuildUtils.isPrimitive(fieldType) ? BuildUtils.getTypeDescriptor(fieldType) : "Ljava/lang/Object;";
        mv.visitMethodInsn(185, "org/drools/spi/WriteAccessor", BuildUtils.injector(fieldType), "(Ljava/lang/Object;" + argType + ")V");
    }

    public static String buildSignature(Method method) {
        String sig = "(";
        for (Class<?> arg : method.getParameterTypes()) {
            sig = sig + BuildUtils.getTypeDescriptor(arg.getName());
        }
        sig = sig + ")";
        sig = sig + BuildUtils.getTypeDescriptor(method.getReturnType().getName());
        return sig;
    }

    public static int getStackSize(Method m) {
        int stack = 1;
        for (Class<?> klass : m.getParameterTypes()) {
            stack += BuildUtils.sizeOf(klass.getName());
        }
        return stack;
    }

    public TripleFactory getTripleFactory() {
        return this.ruleBase.getConfiguration().getComponentFactory().getTripleFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VirtualPropertyMode {
        MAP,
        TRIPLES;

    }
}

