/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.factmodel.traits.Key;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.NullTraitType;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitType;
import org.drools.factmodel.traits.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitTypeMap<T extends String, K extends Thing<C>, C>
extends TypeHierarchy<Key<Thing<C>>>
implements Map<String, Thing<C>>,
Externalizable {
    private Map<String, Thing<C>> innerMap;
    private BitSet currentTypeCode = new BitSet();

    public TraitTypeMap() {
    }

    public TraitTypeMap(Map map) {
        this.innerMap = map;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public Thing<C> get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public Thing<C> put(String key, Thing<C> value) {
        BitSet code = ((TraitType)((Object)value)).getTypeCode();
        this.addMember(new Key<Thing<C>>(System.identityHashCode(value), value), code);
        this.innerMap.put(key, value);
        this.currentTypeCode.or(code);
        return value;
    }

    @Override
    public void setBottomCode(BitSet code) {
        if (!this.hasKey(code)) {
            super.setBottomCode(code);
            this.addMember(new Key<NullTraitType>(0, new NullTraitType(code)), code);
        }
    }

    public Thing<C> putSafe(String key, Thing<C> value) throws LogicalTypeInconsistencyException {
        BitSet code = ((TraitType)((Object)value)).getTypeCode();
        this.addMember(new Key<Thing<C>>(System.identityHashCode(value), value), code);
        this.currentTypeCode.or(code);
        this.innerMap.put(key, value);
        return value;
    }

    @Override
    public Thing<C> remove(Object key) {
        Thing<C> t = this.innerMap.remove(key);
        if (t instanceof TraitProxy) {
            ((TraitProxy)((Object)t)).shed();
        }
        this.removeMember(new Key<Thing<C>>(System.identityHashCode(t), t));
        this.resetCurrentCode();
        return t;
    }

    public Collection<Thing<C>> removeCascade(String traitName) {
        if (!this.innerMap.containsKey(traitName)) {
            return Collections.emptyList();
        }
        Thing<C> thing = this.innerMap.get(traitName);
        return this.removeCascade(((TraitType)((Object)thing)).getTypeCode());
    }

    public Collection<Thing<C>> removeCascade(BitSet code) {
        Collection subs = this.lowerDescendants(code);
        ArrayList<Thing<C>> ret = new ArrayList<Thing<C>>(subs.size());
        for (Key t : subs) {
            TraitType tt = (TraitType)t.getValue();
            if (tt.isVirtual()) continue;
            ret.add((Thing<C>)t.getValue());
            this.removeMember(tt.getTypeCode());
            Thing<C> thing = this.innerMap.remove(tt.getTraitName());
            if (!(thing instanceof TraitProxy)) continue;
            ((TraitProxy)((Object)thing)).shed();
        }
        this.resetCurrentCode();
        return ret;
    }

    private void resetCurrentCode() {
        this.currentTypeCode = new BitSet(this.currentTypeCode.length());
        if (!this.values().isEmpty()) {
            for (Thing<C> x : this.values()) {
                this.currentTypeCode.or(((TraitType)((Object)x)).getTypeCode());
            }
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Thing<C>> m) {
        for (String string : m.keySet()) {
            Thing<C> proxy = m.get(string);
            this.addMember(new Key<Thing<C>>(System.identityHashCode(proxy), proxy), ((TraitProxy)((Object)proxy)).getTypeCode());
        }
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<Thing<C>> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<String, Thing<C>>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public String toString() {
        return "VetoableTypedMap{innerMap=" + this.innerMap + '}';
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.innerMap.size());
        ArrayList<String> keys = new ArrayList<String>(this.innerMap.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            objectOutput.writeObject(k);
            objectOutput.writeObject(this.innerMap.get(k));
        }
        objectOutput.writeObject(this.currentTypeCode);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.innerMap = new HashMap<String, Thing<C>>();
        int n = objectInput.readInt();
        for (int j = 0; j < n; ++j) {
            String k = (String)objectInput.readObject();
            Thing tf = (Thing)objectInput.readObject();
            this.innerMap.put(k, tf);
        }
        this.currentTypeCode = (BitSet)objectInput.readObject();
    }

    public Collection<Key<Thing<C>>> getMostSpecificTraits() {
        if (this.hasKey(this.getBottomCode())) {
            Key b = (Key)this.getMember(this.getBottomCode());
            if (((TraitType)b.getValue()).isVirtual()) {
                Collection<Key<Thing<C>>> p = this.parents(this.getBottomCode());
                return p;
            }
            return Collections.singleton(b);
        }
        Collection<Key<Thing<C>>> p = this.immediateParents(this.getBottomCode());
        return p;
    }

    public BitSet getCurrentTypeCode() {
        return this.currentTypeCode;
    }
}

