/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.List;
import org.drools.factmodel.traits.TypeLattice;
import org.drools.util.AbstractCodedHierarchyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHierarchy<T>
extends AbstractCodedHierarchyImpl<T>
implements TypeLattice<T>,
Externalizable {
    private BitSet bottom;
    private BitSet top;

    public TypeHierarchy() {
        this.top = new BitSet();
    }

    public TypeHierarchy(T topElement, BitSet topKey, T bottomElement, BitSet bottomKey) {
        this.top = topKey;
        this.bottom = bottomKey;
        this.addMember(topElement, topKey);
        this.addMember(bottomElement, bottomKey);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.bottom);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.bottom = (BitSet)objectInput.readObject();
    }

    @Override
    protected AbstractCodedHierarchyImpl.HierNode<T> getNode(T name) {
        throw new UnsupportedOperationException("Concrete Type lattices should be indexed by key (BitSet), not by value");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("***************************************** \n");
        List sorted = this.getSortedMembers();
        for (Object member : sorted) {
            AbstractCodedHierarchyImpl.HierNode node = null;
            for (AbstractCodedHierarchyImpl.HierNode n : this.line.values()) {
                if (!member.equals(n.getValue())) continue;
                node = n;
                break;
            }
            if (node == null) {
                throw new IllegalStateException("Serious corruption: member node is no longer in the lattice");
            }
            sb.append(member).append(" >>> ").append(node.getBitMask()).append("\n");
            sb.append("\t parents ").append(node.getParents()).append("\n ");
            sb.append("\t children ").append(node.getChildren()).append("\n ");
        }
        sb.append("***************************************** \n");
        return sb.toString();
    }

    @Override
    public BitSet getTopCode() {
        return this.top;
    }

    @Override
    public BitSet getBottomCode() {
        return this.bottom;
    }

    @Override
    public void setBottomCode(BitSet bottom) {
        this.bottom = bottom;
    }

    @Override
    public void setTopCode(BitSet top) {
        this.top = top;
    }
}

