/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.factmodel.traits.Key;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitTypeMap;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.util.HierarchyEncoderImpl;

public class TraitObjectTypeNode
extends ObjectTypeNode {
    private BitSet typeMask;

    public TraitObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, source, objectType, context);
        this.typeMask = context.getRuleBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy().getCode(((ClassObjectType)objectType).getClassName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.typeMask = (BitSet)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.typeMask);
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (factHandle.getObject() instanceof TraitProxy) {
            boolean isVetoed;
            BitSet vetoMask = ((TraitProxy)factHandle.getObject()).getTypeFilter();
            boolean bl = isVetoed = vetoMask != null && !this.typeMask.isEmpty() && HierarchyEncoderImpl.supersetOrEqualset(vetoMask, this.typeMask);
            if (!isVetoed || this.sameAndNotCoveredByDescendants((TraitProxy)factHandle.getObject(), this.typeMask)) {
                super.assertObject(factHandle, context, workingMemory);
            }
        } else {
            super.assertObject(factHandle, context, workingMemory);
        }
    }

    private boolean sameAndNotCoveredByDescendants(TraitProxy proxy, BitSet typeMask) {
        boolean isSameType = typeMask.equals(proxy.getTypeCode());
        if (isSameType) {
            Collection descs = ((TraitTypeMap)proxy.getObject()._getTraitMap()).children(typeMask);
            return descs.size() <= 1;
        }
        return false;
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.resetIdGenerator();
            TraitObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        context.setObjectType(this.objectType);
        if (this.compiledNetwork != null) {
            this.compiledNetwork.modifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
        } else if (factHandle.getObject() instanceof TraitProxy) {
            TraitProxy proxy = (TraitProxy)factHandle.getObject();
            BitSet vetoMask = proxy.getTypeFilter();
            if (vetoMask == null || this.typeMask.isEmpty() || !HierarchyEncoderImpl.supersetOrEqualset(vetoMask, this.typeMask)) {
                if (context.getModificationMask() == Long.MIN_VALUE) {
                    TraitableBean txBean = proxy.getObject();
                    TraitTypeMap tMap = (TraitTypeMap)txBean._getTraitMap();
                    Collection x = tMap.immediateParents(this.typeMask);
                    Key k = (Key)x.iterator().next();
                    long originalMask = context.getModificationMask();
                    if (!((Thing)k.getValue()).isTop()) {
                        ((PropagationContextImpl)context).setModificationMask(-1L);
                    }
                    this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
                    ((PropagationContextImpl)context).setModificationMask(originalMask);
                } else {
                    this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
                }
            }
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.getModificationMask() > 0L ? context.adaptModificationMaskForObjectType(this.objectType, workingMemory) : context, workingMemory);
        }
    }

    public boolean needsMaskUpdate() {
        return true;
    }

    public long updateMask(long mask) {
        long returnMask = this.declaredMask | mask;
        this.inferredMask |= returnMask;
        return returnMask;
    }
}

