/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jbpm.task.identity.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUserGroupCallbackImpl
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(DBUserGroupCallbackImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "/jbpm.usergroup.callback.properties";
    public static final String DS_JNDI_NAME = "db.ds.jndi.name";
    public static final String PRINCIPAL_QUERY = "db.user.query";
    public static final String USER_ROLES_QUERY = "db.user.roles.query";
    public static final String ROLES_QUERY = "db.roles.query";
    private Properties config;
    private DataSource ds;

    public DBUserGroupCallbackImpl() {
        String propertiesLocation = System.getProperty("jbpm.usergroup.callback.properties");
        if (propertiesLocation == null) {
            propertiesLocation = DEFAULT_PROPERTIES_NAME;
        }
        logger.debug("Callback properties will be loaded from " + propertiesLocation);
        InputStream in = this.getClass().getResourceAsStream(propertiesLocation);
        if (in != null) {
            this.config = new Properties();
            try {
                this.config.load(in);
            }
            catch (IOException e) {
                logger.error("Error when loading properties for DB user group callback", (Throwable)e);
                this.config = null;
            }
        }
        this.init();
    }

    public DBUserGroupCallbackImpl(Properties config) {
        this.config = config;
        this.init();
    }

    @Override
    public boolean existsUser(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("UserId cannot be null");
        }
        return this.checkExistence(this.config.getProperty(PRINCIPAL_QUERY), userId);
    }

    @Override
    public boolean existsGroup(String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException("GroupId cannot be null");
        }
        return this.checkExistence(this.config.getProperty(ROLES_QUERY), groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        if (userId == null) {
            throw new IllegalArgumentException("UserId cannot be null");
        }
        ArrayList<String> roles = new ArrayList<String>();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.config.getProperty(USER_ROLES_QUERY));
            try {
                ps.setString(1, userId);
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                roles.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            logger.error("Error when checking roles in db, parameter: " + userId, (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        return roles;
    }

    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void init() {
        if (!(this.config != null && this.config.containsKey(DS_JNDI_NAME) && this.config.containsKey(PRINCIPAL_QUERY) && this.config.containsKey(ROLES_QUERY) && this.config.containsKey(USER_ROLES_QUERY))) {
            throw new IllegalArgumentException("All properties must be given (db.ds.jndi.name,db.user.roles.query,db.roles.query,db.user.roles.query)");
        }
        String jndiName = this.config.getProperty(DS_JNDI_NAME, "java:/DefaultDS");
        try {
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup(jndiName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can get data source for DB usergroup callback, JNDI name: " + jndiName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkExistence(String querySql, String parameter) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean result = false;
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(querySql);
            ps.setString(1, parameter);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error("Error when checking user/group in db, parameter: " + parameter, (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }
}

