/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.gui.client.comments;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.DisclosureLayoutPanel;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.monitor.gui.client.comments.ChartComment;
import org.jboss.bpm.monitor.gui.client.comments.CommentEditCallback;

public class CommentPanel
extends DisclosureLayoutPanel {
    private DeckLayoutPanel commentDeck;
    private LayoutPanel editPanel;
    private LayoutPanel listPanel;
    private ListBox<ChartComment> comments;
    private CommentEditCallback callbackComment;
    private ChartComment suggestion = null;
    private TextArea textBox;

    public CommentPanel(final CommentEditCallback callbackComment) {
        super("Comments");
        this.callbackComment = callbackComment;
        this.commentDeck = new DeckLayoutPanel();
        this.editPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        this.textBox = new TextArea();
        this.textBox.setCharacterWidth(50);
        this.textBox.setVisibleLines(2);
        this.editPanel.add((Widget)this.textBox);
        this.editPanel.add((Widget)new Button("Save", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CommentPanel.this.suggestion.setTitle(CommentPanel.this.textBox.getText());
                CommentPanel.this.addComment(CommentPanel.this.suggestion);
                callbackComment.onSaveComment(CommentPanel.this.suggestion);
                CommentPanel.this.resetEditState();
            }
        }));
        HTML cancel = new HTML("cancel");
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                callbackComment.onCancelComment(CommentPanel.this.suggestion);
                CommentPanel.this.resetEditState();
            }
        });
        this.editPanel.add((Widget)cancel);
        this.listPanel = new LayoutPanel();
        this.comments = new ListBox(new String[]{"Title", ""});
        this.comments.setCellRenderer((ListBox.CellRenderer)new ListBox.CellRenderer<ChartComment>(){

            public void renderCell(ListBox listBox, int row, int col, final ChartComment item) {
                switch (col) {
                    case 0: {
                        listBox.setText(row, col, item.getTitle());
                        break;
                    }
                    case 1: {
                        HTML html = new HTML("delete");
                        html.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                callbackComment.onDeleteComment(item);
                                DefaultListModel model = (DefaultListModel)CommentPanel.this.comments.getModel();
                                model.remove((Object)item);
                            }
                        });
                        listBox.setWidget(row, col, (Widget)html);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal column");
                    }
                }
            }
        });
        this.listPanel.add(this.comments);
        this.commentDeck.add((Widget)this.listPanel);
        this.commentDeck.add((Widget)this.editPanel);
        this.add((Widget)this.commentDeck);
    }

    public void toogleListView() {
        if (this.isCollapsed()) {
            this.setCollapsed(false);
        }
        this.commentDeck.showWidget(0);
        this.layout();
    }

    public void toogleEditView(ChartComment comment) {
        if (this.isCollapsed()) {
            this.setCollapsed(false);
        }
        this.commentDeck.showWidget(1);
        this.suggestion = comment;
        if (comment.getId() != 0L) {
            this.textBox.setText(comment.getTitle());
        }
        this.layout();
    }

    private void addComment(ChartComment comment) {
        DefaultListModel model = (DefaultListModel)this.comments.getModel();
        model.add((Object)comment);
        comment.setId(model.getSize());
    }

    private void resetEditState() {
        this.textBox.setText("");
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                CommentPanel.this.setCollapsed(true);
                CommentPanel.this.layout();
            }
        });
    }

    public void reset() {
        this.suggestion = null;
        DefaultListModel model = (DefaultListModel)this.comments.getModel();
        model.clear();
        this.textBox.setText("");
    }
}

