/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindException
extends Exception
implements BindingResult {
    private final BindingResult bindingResult;

    public BindException(BindingResult bindingResult) {
        Assert.notNull((Object)bindingResult, (String)"BindingResult must not be null");
        this.bindingResult = bindingResult;
    }

    public BindException(Object target, String objectName) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        this.bindingResult = new BeanPropertyBindingResult(target, objectName);
    }

    public final BindingResult getBindingResult() {
        return this.bindingResult;
    }

    @Override
    public String getObjectName() {
        return this.bindingResult.getObjectName();
    }

    @Override
    public void setNestedPath(String nestedPath) {
        this.bindingResult.setNestedPath(nestedPath);
    }

    @Override
    public String getNestedPath() {
        return this.bindingResult.getNestedPath();
    }

    @Override
    public void pushNestedPath(String subPath) {
        this.bindingResult.pushNestedPath(subPath);
    }

    @Override
    public void popNestedPath() throws IllegalStateException {
        this.bindingResult.popNestedPath();
    }

    @Override
    public void reject(String errorCode) {
        this.bindingResult.reject(errorCode);
    }

    @Override
    public void reject(String errorCode, String defaultMessage) {
        this.bindingResult.reject(errorCode, defaultMessage);
    }

    @Override
    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.bindingResult.reject(errorCode, errorArgs, defaultMessage);
    }

    @Override
    public void rejectValue(String field, String errorCode) {
        this.bindingResult.rejectValue(field, errorCode);
    }

    @Override
    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.bindingResult.rejectValue(field, errorCode, defaultMessage);
    }

    @Override
    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.bindingResult.rejectValue(field, errorCode, errorArgs, defaultMessage);
    }

    @Override
    public void addAllErrors(Errors errors) {
        this.bindingResult.addAllErrors(errors);
    }

    @Override
    public boolean hasErrors() {
        return this.bindingResult.hasErrors();
    }

    @Override
    public int getErrorCount() {
        return this.bindingResult.getErrorCount();
    }

    public List getAllErrors() {
        return this.bindingResult.getAllErrors();
    }

    @Override
    public boolean hasGlobalErrors() {
        return this.bindingResult.hasGlobalErrors();
    }

    @Override
    public int getGlobalErrorCount() {
        return this.bindingResult.getGlobalErrorCount();
    }

    public List getGlobalErrors() {
        return this.bindingResult.getGlobalErrors();
    }

    @Override
    public ObjectError getGlobalError() {
        return this.bindingResult.getGlobalError();
    }

    @Override
    public boolean hasFieldErrors() {
        return this.bindingResult.hasFieldErrors();
    }

    @Override
    public int getFieldErrorCount() {
        return this.bindingResult.getFieldErrorCount();
    }

    public List getFieldErrors() {
        return this.bindingResult.getFieldErrors();
    }

    @Override
    public FieldError getFieldError() {
        return this.bindingResult.getFieldError();
    }

    @Override
    public boolean hasFieldErrors(String field) {
        return this.bindingResult.hasFieldErrors(field);
    }

    @Override
    public int getFieldErrorCount(String field) {
        return this.bindingResult.getFieldErrorCount(field);
    }

    public List getFieldErrors(String field) {
        return this.bindingResult.getFieldErrors(field);
    }

    @Override
    public FieldError getFieldError(String field) {
        return this.bindingResult.getFieldError(field);
    }

    @Override
    public Object getFieldValue(String field) {
        return this.bindingResult.getFieldValue(field);
    }

    @Override
    public Class getFieldType(String field) {
        return this.bindingResult.getFieldType(field);
    }

    @Override
    public Object getTarget() {
        return this.bindingResult.getTarget();
    }

    @Override
    public Map<String, Object> getModel() {
        return this.bindingResult.getModel();
    }

    @Override
    public Object getRawFieldValue(String field) {
        return this.bindingResult.getRawFieldValue(field);
    }

    public PropertyEditor findEditor(String field, Class valueType) {
        return this.bindingResult.findEditor(field, valueType);
    }

    @Override
    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.bindingResult.getPropertyEditorRegistry();
    }

    @Override
    public void addError(ObjectError error) {
        this.bindingResult.addError(error);
    }

    @Override
    public String[] resolveMessageCodes(String errorCode, String field) {
        return this.bindingResult.resolveMessageCodes(errorCode, field);
    }

    @Override
    public void recordSuppressedField(String field) {
        this.bindingResult.recordSuppressedField(field);
    }

    @Override
    public String[] getSuppressedFields() {
        return this.bindingResult.getSuppressedFields();
    }

    @Override
    public String getMessage() {
        return this.bindingResult.toString();
    }

    public boolean equals(Object other) {
        return this == other || this.bindingResult.equals(other);
    }

    public int hashCode() {
        return this.bindingResult.hashCode();
    }
}

