/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.utils.Encoder;
import bitronix.tm.utils.Uid;

public class UidGenerator {
    private static int sequenceNumber = 0;

    public static Uid generateUid() {
        byte[] timestamp = Encoder.longToBytes(System.currentTimeMillis());
        byte[] sequence = Encoder.intToBytes(UidGenerator.getNextSequenceNumber());
        byte[] serverId = TransactionManagerServices.getConfiguration().buildServerIdArray();
        int uidLength = serverId.length + timestamp.length + sequence.length;
        byte[] uidArray = new byte[uidLength];
        System.arraycopy(serverId, 0, uidArray, 0, serverId.length);
        System.arraycopy(timestamp, 0, uidArray, serverId.length, timestamp.length);
        System.arraycopy(sequence, 0, uidArray, serverId.length + timestamp.length, sequence.length);
        return new Uid(uidArray);
    }

    public static synchronized int getNextSequenceNumber() {
        return sequenceNumber++;
    }

    public static BitronixXid generateXid(Uid gtrid) {
        return new BitronixXid(gtrid, UidGenerator.generateUid());
    }
}

