/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TransactionRequiredException;
import javax.transaction.UserTransaction;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.audit.event.RuleFlowVariableLogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.process.ProcessCompletedEvent;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.event.ExtendedRuleFlowLogEvent;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAWorkingMemoryDbLogger
extends WorkingMemoryLogger {
    private static Logger logger = LoggerFactory.getLogger(JPAWorkingMemoryDbLogger.class);
    private static final String[] KNOWN_UT_JNDI_KEYS = new String[]{"UserTransaction", "java:jboss/UserTransaction", System.getProperty("jbpm.ut.jndi.lookup")};
    protected Environment env;
    private boolean isJTA = true;
    private boolean sharedEM = false;

    public JPAWorkingMemoryDbLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        this.env = workingMemory.getEnvironment();
    }

    public JPAWorkingMemoryDbLogger(KnowledgeRuntimeEventManager session) {
        super(session);
        if (session instanceof KnowledgeRuntime) {
            this.env = ((KnowledgeRuntime)session).getEnvironment();
        } else if (session instanceof StatelessKnowledgeSessionImpl) {
            this.env = ((StatelessKnowledgeSessionImpl)session).getEnvironment();
        } else {
            throw new IllegalArgumentException("Not supported session in logger: " + session.getClass());
        }
        Boolean bool = (Boolean)this.env.get("IS_JTA_TRANSACTION");
        if (bool != null) {
            this.isJTA = bool;
        }
    }

    public void logEventCreated(LogEvent logEvent) {
        switch (logEvent.getType()) {
            case 8: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.addProcessLog(processEvent);
                break;
            }
            case 11: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.updateProcessLog(processEvent);
                break;
            }
            case 24: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeEnterLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId(), nodeEvent.getNodeName());
                break;
            }
            case 26: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeExitLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId(), nodeEvent.getNodeName());
                break;
            }
            case 33: {
                RuleFlowVariableLogEvent variableEvent = (RuleFlowVariableLogEvent)logEvent;
                this.addVariableLog(variableEvent.getProcessInstanceId(), variableEvent.getProcessId(), variableEvent.getVariableInstanceId(), variableEvent.getVariableId(), variableEvent.getObjectToString());
                break;
            }
        }
    }

    private void addProcessLog(RuleFlowLogEvent processEvent) {
        ProcessInstanceLog log = new ProcessInstanceLog(processEvent.getProcessInstanceId(), processEvent.getProcessId());
        if (processEvent instanceof ExtendedRuleFlowLogEvent) {
            log.setParentProcessInstanceId(((ExtendedRuleFlowLogEvent)processEvent).getParentProcessInstanceId());
        }
        this.persist(log);
    }

    private void updateProcessLog(RuleFlowLogEvent processEvent) {
        EntityManager em = this.getEntityManager();
        UserTransaction ut = this.joinTransaction(em);
        List result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = ? and log.end is null").setParameter(1, (Object)processEvent.getProcessInstanceId()).getResultList();
        if (result != null && result.size() != 0) {
            ProcessInstanceLog log = (ProcessInstanceLog)result.get(result.size() - 1);
            log.setEnd(new Date());
            if (processEvent instanceof ExtendedRuleFlowLogEvent) {
                log.setStatus(((ExtendedRuleFlowLogEvent)processEvent).getProcessInstanceState());
                log.setOutcome(((ExtendedRuleFlowLogEvent)processEvent).getOutcome());
            }
            em.merge((Object)log);
        }
        if (!this.sharedEM) {
            JPAWorkingMemoryDbLogger.flush(em, ut);
        }
    }

    private void addNodeEnterLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        NodeInstanceLog log = new NodeInstanceLog(0, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        this.persist(log);
    }

    private void addNodeExitLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        NodeInstanceLog log = new NodeInstanceLog(1, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        this.persist(log);
    }

    private void addVariableLog(long processInstanceId, String processId, String variableInstanceId, String variableId, String objectToString) {
        VariableInstanceLog log = new VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, objectToString);
        this.persist(log);
    }

    public void dispose() {
    }

    private EntityManager getEntityManager() {
        EntityManager em = (EntityManager)this.env.get("drools.persistence.jpa.CmdScopedEntityManager");
        if (em != null) {
            this.sharedEM = true;
            return em;
        }
        EntityManagerFactory emf = (EntityManagerFactory)this.env.get("drools.persistence.jpa.EntityManagerFactory");
        if (emf != null) {
            return emf.createEntityManager();
        }
        throw new RuntimeException("Could not find EntityManager, both command-scoped EM and EMF in environment are null");
    }

    private void persist(Object entity) {
        EntityManager em = this.getEntityManager();
        UserTransaction ut = this.joinTransaction(em);
        em.persist(entity);
        if (!this.sharedEM) {
            JPAWorkingMemoryDbLogger.flush(em, ut);
        }
    }

    private UserTransaction joinTransaction(EntityManager em) {
        boolean newTx = false;
        UserTransaction ut = null;
        if (this.isJTA) {
            block7: {
                try {
                    em.joinTransaction();
                }
                catch (TransactionRequiredException e) {
                    ut = JPAWorkingMemoryDbLogger.findUserTransaction();
                    try {
                        if (ut != null && ut.getStatus() == 6) {
                            ut.begin();
                            newTx = true;
                            em.joinTransaction();
                        }
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Unable to find or open a transaction: " + ex.getMessage(), ex);
                    }
                    if (newTx) break block7;
                    throw e;
                }
            }
            if (newTx) {
                return ut;
            }
        }
        return null;
    }

    private static void flush(EntityManager em, UserTransaction ut) {
        em.flush();
        em.clear();
        em.close();
        try {
            if (ut != null) {
                ut.commit();
            }
        }
        catch (Exception e) {
            logger.error("Unable to commit transaction: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        long parentProcessInstanceId = -1L;
        try {
            ProcessInstanceImpl processInstance = (ProcessInstanceImpl)event.getProcessInstance();
            parentProcessInstanceId = (Long)processInstance.getMetaData().get("ParentProcessInstanceId");
        }
        catch (Exception e) {
            // empty catch block
        }
        ExtendedRuleFlowLogEvent logEvent = new ExtendedRuleFlowLogEvent(8, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId(), parentProcessInstanceId);
        this.logEventCreated((LogEvent)logEvent);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        String outcome = null;
        try {
            ProcessInstanceImpl processInstance = (ProcessInstanceImpl)event.getProcessInstance();
            outcome = processInstance.getOutcome();
        }
        catch (Exception e) {
            // empty catch block
        }
        ExtendedRuleFlowLogEvent logEvent = new ExtendedRuleFlowLogEvent(11, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId(), event.getProcessInstance().getState(), outcome);
        this.logEventCreated((LogEvent)logEvent);
    }

    protected static UserTransaction findUserTransaction() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            return (UserTransaction)context.lookup("java:comp/UserTransaction");
        }
        catch (NamingException ex) {
            for (String utLookup : KNOWN_UT_JNDI_KEYS) {
                if (utLookup == null) continue;
                try {
                    UserTransaction ut = (UserTransaction)context.lookup(utLookup);
                    return ut;
                }
                catch (NamingException e) {
                    logger.debug("User Transaction not found in JNDI under " + utLookup);
                }
            }
            logger.warn("No user transaction found under known names");
            return null;
        }
    }
}

