/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;

@Entity
@SequenceGenerator(name="booleanExprIdSeq", sequenceName="BOOLEANEXPR_ID_SEQ", allocationSize=1)
public class BooleanExpression
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="booleanExprIdSeq")
    private long id;
    private String type;
    @Lob
    @Column(length=65535)
    private String expression;

    public BooleanExpression() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.type == null) {
            this.type = "";
        }
        out.writeUTF(this.type);
        if (this.expression == null) {
            this.expression = "";
        }
        out.writeUTF(this.expression);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.type = in.readUTF();
        this.expression = in.readUTF();
    }

    public BooleanExpression(String type, String expression) {
        this.type = type;
        this.expression = expression;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanExpression)) {
            return false;
        }
        BooleanExpression other = (BooleanExpression)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

