/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.SystemEventListener;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Task;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.CommandName;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.EventTransport;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.IllegalTaskStateException;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.SessionWriter;
import org.jbpm.task.service.TaskException;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(TaskServerHandler.class);
    private final TaskService service;
    private final Map<String, SessionWriter> clients;
    private final SystemEventListener systemEventListener;

    public TaskServerHandler(TaskService service, SystemEventListener systemEventListener) {
        this.service = service;
        this.clients = new HashMap<String, SessionWriter>();
        this.systemEventListener = systemEventListener;
    }

    public void exceptionCaught(SessionWriter session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on Server", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(final SessionWriter session, Object message) throws Exception {
        final Command cmd = (Command)message;
        final TaskServiceSession taskSession = this.service.createSession();
        CommandName response = null;
        try {
            this.systemEventListener.debug("Message receieved on server : " + (Object)((Object)cmd.getName()));
            this.systemEventListener.debug("Arguments : " + Arrays.toString(cmd.getArguments().toArray()));
            switch (cmd.getName()) {
                case OperationRequest: {
                    response = CommandName.OperationResponse;
                    Operation operation = (Operation)((Object)cmd.getArguments().get(0));
                    this.systemEventListener.debug("Command receieved on server was operation of type: " + (Object)((Object)operation));
                    long taskId = (Long)cmd.getArguments().get(1);
                    String userId = (String)cmd.getArguments().get(2);
                    String targetEntityId = null;
                    ContentData data = null;
                    List groupIds = null;
                    if (cmd.getArguments().size() > 3) {
                        targetEntityId = (String)cmd.getArguments().get(3);
                        if (cmd.getArguments().size() > 4) {
                            data = (ContentData)cmd.getArguments().get(4);
                            if (cmd.getArguments().size() > 5) {
                                groupIds = (List)cmd.getArguments().get(5);
                            }
                        }
                    }
                    taskSession.taskOperation(operation, taskId, userId, targetEntityId, data, groupIds);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case ClaimNextAvailableRequest: {
                    response = CommandName.OperationResponse;
                    this.systemEventListener.debug("Command receieved on server was operation of type: " + (Object)((Object)CommandName.ClaimNextAvailableRequest));
                    String userId = (String)cmd.getArguments().get(0);
                    String language = (String)cmd.getArguments().get(1);
                    if (cmd.getArguments().size() == 2) {
                        taskSession.claimNextAvailable(userId, language);
                    } else if (cmd.getArguments().size() == 3) {
                        List groupIds = (List)cmd.getArguments().get(2);
                        taskSession.claimNextAvailable(userId, groupIds, language);
                    }
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), response, args);
                    session.write(resultsCmnd);
                    return;
                }
                case GetTaskRequest: {
                    response = CommandName.GetTaskResponse;
                    final long taskId = (Long)cmd.getArguments().get(0);
                    taskSession.doOperationInTransaction(new TaskServiceSession.TransactedOperation(){

                        public void doOperation() {
                            Task task = taskSession.getTask(taskId);
                            List<Object> args = Arrays.asList(task);
                            Command resultsCmnd = new Command(cmd.getId(), CommandName.GetTaskResponse, args);
                            try {
                                session.write(resultsCmnd);
                            }
                            catch (IOException ioe) {
                                throw new IllegalTaskStateException("Could not serialize Task instance.", ioe);
                            }
                        }
                    });
                    return;
                }
                case AddTaskRequest: {
                    response = CommandName.AddTaskResponse;
                    Task task = (Task)cmd.getArguments().get(0);
                    ContentData content = (ContentData)cmd.getArguments().get(1);
                    taskSession.addTask(task, content);
                    List<Object> args = Arrays.asList(task.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddTaskResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case AddCommentRequest: {
                    response = CommandName.AddCommentResponse;
                    Comment comment = (Comment)cmd.getArguments().get(1);
                    taskSession.addComment((Long)cmd.getArguments().get(0), comment);
                    List<Object> args = Arrays.asList(comment.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddCommentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case DeleteCommentRequest: {
                    response = CommandName.DeleteCommentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    long commentId = (Long)cmd.getArguments().get(1);
                    taskSession.deleteComment(taskId, commentId);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.DeleteCommentResponse, Collections.<Object>emptyList());
                    session.write(resultsCmnd);
                    return;
                }
                case AddAttachmentRequest: {
                    response = CommandName.AddAttachmentResponse;
                    Attachment attachment = (Attachment)cmd.getArguments().get(1);
                    Content content = (Content)cmd.getArguments().get(2);
                    taskSession.addAttachment((Long)cmd.getArguments().get(0), attachment, content);
                    List<Object> args = Arrays.asList(attachment.getId(), content.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddAttachmentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case DeleteAttachmentRequest: {
                    response = CommandName.DeleteAttachmentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    long attachmentId = (Long)cmd.getArguments().get(1);
                    long contentId = (Long)cmd.getArguments().get(2);
                    taskSession.deleteAttachment(taskId, attachmentId, contentId);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.DeleteAttachmentResponse, Collections.<Object>emptyList());
                    session.write(resultsCmnd);
                    return;
                }
                case SetDocumentContentRequest: {
                    response = CommandName.SetDocumentContentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    Content content = (Content)cmd.getArguments().get(1);
                    taskSession.setDocumentContent(taskId, content);
                    List<Object> args = Arrays.asList(content.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.SetDocumentContentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case GetContentRequest: {
                    response = CommandName.GetContentResponse;
                    final long contentId = (Long)cmd.getArguments().get(0);
                    taskSession.doOperationInTransaction(new TaskServiceSession.TransactedOperation(){

                        public void doOperation() throws Exception {
                            Content content = taskSession.getContent(contentId);
                            List<Object> args = Arrays.asList(content);
                            Command resultsCmnd = new Command(cmd.getId(), CommandName.GetContentResponse, args);
                            session.write(resultsCmnd);
                        }
                    });
                    return;
                }
                case QueryTaskByWorkItemId: {
                    response = CommandName.QueryTaskByWorkItemIdResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    taskSession.doOperationInTransaction(new TaskServiceSession.TransactedOperation(){

                        public void doOperation() {
                            Task result = taskSession.getTaskByWorkItemId((Long)cmd.getArguments().get(0));
                            List<Object> args = Arrays.asList(result);
                            Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskByWorkItemIdResponse, args);
                            try {
                                session.write(resultsCmnd);
                            }
                            catch (IOException ioe) {
                                throw new IllegalTaskStateException("Could not serialize Task instance.", ioe);
                            }
                        }
                    });
                    return;
                }
                case QueryTasksOwned: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksOwned((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksOwnedWithParticularStatus: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksOwned((String)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsBusinessAdministrator: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsBusinessAdministrator((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwner((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerByStatus: {
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwnerByStatus((String)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerByStatusByGroup: {
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwnerByStatusByGroup((String)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (List)cmd.getArguments().get(2), (String)cmd.getArguments().get(3));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerWithGroup: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwner((String)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2), (Integer)cmd.getArguments().get(3), (Integer)cmd.getArguments().get(4));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerByGroup: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwnerByGroup((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QuerySubTasksAssignedAsPotentialOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getSubTasksAssignedAsPotentialOwner((Long)cmd.getArguments().get(0), (String)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryGetSubTasksByParentTaskId: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getSubTasksByParent((Long)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsTaskInitiator: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsTaskInitiator((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsExcludedOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsExcludedOwner((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsRecipient: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsRecipient((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsTaskStakeholder: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsTaskStakeholder((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksByStatusByProcessId: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksByStatusByProcessId((Long)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksByStatusByProcessIdByTaskName: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksByStatusByProcessIdByTaskName((Long)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2), (String)cmd.getArguments().get(3));
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case RegisterForEventRequest: {
                    response = CommandName.EventTriggerResponse;
                    EventKey key = (EventKey)cmd.getArguments().get(0);
                    boolean remove = (Boolean)cmd.getArguments().get(1);
                    String uuid = (String)cmd.getArguments().get(2);
                    this.clients.put(uuid, session);
                    EventTransport transport = new EventTransport(uuid, cmd.getId(), this.clients, remove);
                    this.service.getEventKeys().register(key, transport);
                    return;
                }
                case UnRegisterForEventRequest: {
                    EventKey key = (EventKey)cmd.getArguments().get(0);
                    String uuid = (String)cmd.getArguments().get(1);
                    this.clients.put(uuid, session);
                    this.service.getEventKeys().removeKey(key);
                    return;
                }
                case RegisterClient: {
                    response = CommandName.RegisterClient;
                    String uuid = (String)cmd.getArguments().get(0);
                    this.clients.put(uuid, session);
                    return;
                }
                case QueryGenericRequest: {
                    String qlString = (String)cmd.getArguments().get(0);
                    Integer size = (Integer)cmd.getArguments().get(1);
                    Integer offset = (Integer)cmd.getArguments().get(2);
                    List<?> results = taskSession.query(qlString, size, offset);
                    List<Object> args = Arrays.asList(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryGenericResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case NominateTaskRequest: {
                    response = CommandName.OperationResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    String userId = (String)cmd.getArguments().get(1);
                    List potentialOwners = (List)cmd.getArguments().get(2);
                    taskSession.nominateTask(taskId, userId, potentialOwners);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case SetOutputRequest: {
                    response = CommandName.OperationResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    String userId = (String)cmd.getArguments().get(1);
                    ContentData outputContentData = (ContentData)cmd.getArguments().get(2);
                    taskSession.setOutput(taskId, userId, outputContentData);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case DeleteOutputRequest: {
                    response = CommandName.OperationResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    String userId = (String)cmd.getArguments().get(1);
                    taskSession.deleteOutput(taskId, userId);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case SetFaultRequest: {
                    response = CommandName.OperationResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    String userId = (String)cmd.getArguments().get(1);
                    FaultData data = (FaultData)cmd.getArguments().get(2);
                    taskSession.setFault(taskId, userId, data);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case DeleteFaultRequest: {
                    response = CommandName.OperationResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    String userId = (String)cmd.getArguments().get(1);
                    taskSession.deleteFault(taskId, userId);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case SetPriorityRequest: {
                    response = CommandName.OperationResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    String userId = (String)cmd.getArguments().get(1);
                    int priority = (Integer)cmd.getArguments().get(2);
                    taskSession.setPriority(taskId, userId, priority);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                default: {
                    this.systemEventListener.debug("Unknown command recieved on server");
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            this.systemEventListener.exception(e.getMessage(), (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            String errorMessage = "Command " + (Object)((Object)cmd.getName()) + " faild due to " + e.getMessage() + ". Please contact task server administrator.";
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (e instanceof TaskException) {
                list.add(e);
            } else {
                list.add(new RuntimeException(errorMessage));
            }
            Command resultsCmnd = new Command(cmd.getId(), response, list);
            session.write(resultsCmnd);
            return;
        }
        finally {
            taskSession.dispose();
        }
    }
}

