/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.TransactionManager;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.admin.TasksAdminImpl;
import org.jbpm.task.event.TaskEventsAdmin;
import org.jbpm.task.event.TaskEventsAdminImpl;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.jbpm.task.service.persistence.TaskSessionFactory;
import org.jbpm.task.service.persistence.TaskSpringTransactionManager;

public class TaskSessionSpringFactoryImpl
implements TaskSessionFactory {
    private EntityManagerFactory emf;
    private EntityManager springEM;
    private Boolean useEMF = null;
    private TransactionManager springTransactionManager;
    private boolean useJTA;
    private TaskService taskService;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
        if (this.springEM == null) {
            this.useEMF = true;
        }
    }

    public void setEntityManager(EntityManager em) {
        this.springEM = em;
        this.useEMF = false;
    }

    public void setTransactionManager(TransactionManager txm) {
        this.springTransactionManager = txm;
    }

    public void setUseJTA(boolean useJTA) {
        this.useJTA = useJTA;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public TaskServiceSession createTaskServiceSession() {
        return new TaskServiceSession(this.taskService, this.createTaskPersistenceManager());
    }

    public TasksAdmin createTaskAdmin() {
        return new TasksAdminImpl(this.createTaskPersistenceManager());
    }

    public void initialize() {
        this.taskService.setTaskSessionFactory(this);
        this.taskService.initialize();
    }

    private TaskPersistenceManager createTaskPersistenceManager() {
        TaskPersistenceManager tpm;
        TaskSpringTransactionManager ttxm = new TaskSpringTransactionManager(this.springTransactionManager, this.useJTA);
        if (this.useEMF.booleanValue()) {
            tpm = new TaskPersistenceManager(this.emf.createEntityManager(), ttxm);
        } else {
            tpm = new TaskPersistenceManager(this.springEM, ttxm);
            tpm.setUseSharedEntityManager(true);
        }
        return tpm;
    }

    public TaskEventsAdmin createTaskEventsAdmin() {
        TaskSpringTransactionManager ttxm = new TaskSpringTransactionManager(this.springTransactionManager, this.useJTA);
        TaskPersistenceManager tpm = this.useEMF != false ? new TaskPersistenceManager(this.emf.createEntityManager(), ttxm) : new TaskPersistenceManager(this.springEM, ttxm);
        return new TaskEventsAdminImpl(tpm);
    }
}

