/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.responsehandlers;

import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.event.TaskEventsAdmin;
import org.jbpm.task.event.entity.TaskUserEvent;
import org.jbpm.task.service.responsehandlers.AbstractBlockingResponseHandler;

public class BlockingEventResponseHandler
extends AbstractBlockingResponseHandler
implements EventResponseHandler {
    private static final int PAYLOAD_WAIT_TIME = 10000;
    private TaskEventsAdmin eventsAdmin;
    private volatile Payload payload;

    public BlockingEventResponseHandler(TaskEventsAdmin eventsAdmin) {
        this.eventsAdmin = eventsAdmin;
    }

    public BlockingEventResponseHandler() {
    }

    public synchronized void execute(Payload payload) {
        this.payload = payload;
        if (this.eventsAdmin != null) {
            this.eventsAdmin.storeEvent((TaskUserEvent)payload.get());
        }
        this.setDone(true);
    }

    public Payload getPayload() {
        boolean done = this.waitTillDone(10000L);
        if (!done) {
            throw new RuntimeException("Timeout : unable to retrieve event payload");
        }
        return this.payload;
    }

    public TaskEventsAdmin getEventsAdmin() {
        return this.eventsAdmin;
    }

    public void setEventsAdmin(TaskEventsAdmin eventsAdmin) {
        this.eventsAdmin = eventsAdmin;
    }

    public boolean isRemove() {
        return true;
    }
}

