/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.common.InternalFactHandle;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFactHandlesInEntryPointCommand
implements GenericCommand<Collection<FactHandle>> {
    private ObjectFilter filter = null;
    private boolean disconnected = false;
    private String entryPoint;

    public GetFactHandlesInEntryPointCommand(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public GetFactHandlesInEntryPointCommand(String entryPoint, ObjectFilter filter) {
        this.entryPoint = entryPoint;
        this.filter = filter;
    }

    public GetFactHandlesInEntryPointCommand(String entryPoint, ObjectFilter filter, boolean disconnected) {
        this.entryPoint = entryPoint;
        this.filter = filter;
        this.disconnected = disconnected;
    }

    public GetFactHandlesInEntryPointCommand(String entryPoint, boolean disconnected) {
        this.entryPoint = entryPoint;
        this.disconnected = disconnected;
    }

    @Override
    public Collection<FactHandle> execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint(this.entryPoint);
        ArrayList<FactHandle> disconnectedFactHandles = new ArrayList<FactHandle>();
        if (this.filter != null) {
            Collection factHandles = ep.getFactHandles(this.filter);
            if (factHandles != null && this.disconnected) {
                for (InternalFactHandle factHandle : factHandles) {
                    InternalFactHandle handle = factHandle.clone();
                    handle.disconnect();
                    disconnectedFactHandles.add(handle);
                }
                return disconnectedFactHandles;
            }
            return ksession.getFactHandles(this.filter);
        }
        Collection factHandles = ep.getFactHandles();
        if (factHandles != null && this.disconnected) {
            for (InternalFactHandle factHandle : factHandles) {
                InternalFactHandle handle = factHandle.clone();
                handle.disconnect();
                disconnectedFactHandles.add(handle);
            }
            return disconnectedFactHandles;
        }
        return ksession.getFactHandles();
    }

    public String toString() {
        if (this.filter != null) {
            return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), null, ObjectStoreWrapper.FACT_HANDLE )";
        }
        return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), filter, ObjectStoreWrapper.FACT_HANDLE )";
    }
}

