/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectsInEntryPointCommand
implements GenericCommand<Collection> {
    @XmlAttribute(name="entry-point")
    private String entryPoint;
    private ObjectFilter filter = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public GetObjectsInEntryPointCommand() {
    }

    public GetObjectsInEntryPointCommand(ObjectFilter filter, String entryPoint) {
        this.filter = filter;
        this.entryPoint = entryPoint;
    }

    public GetObjectsInEntryPointCommand(ObjectFilter filter, String entryPoint, String outIdentifier) {
        this.filter = filter;
        this.entryPoint = entryPoint;
        this.outIdentifier = outIdentifier;
    }

    @Override
    public Collection execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint(this.entryPoint);
        Collection col = null;
        col = this.filter != null ? ep.getObjects(this.filter) : ep.getObjects();
        if (this.outIdentifier != null) {
            ArrayList objects = new ArrayList(col);
            ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult().getResults().put(this.outIdentifier, objects);
        }
        return col;
    }

    public Collection<? extends Object> getObjects(ReteooWorkingMemory session) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(session.getObjectStore(), null, 0);
    }

    public Collection<? extends Object> getObjects(ReteooWorkingMemory session, ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(session.getObjectStore(), filter, 0);
    }

    public String toString() {
        if (this.filter != null) {
            return "session.getWorkingMemoryEntryPoint(" + this.entryPoint + ").iterateObjects( " + this.filter + " );";
        }
        return "session.getWorkingMemoryEntryPoint(" + this.entryPoint + ").iterateObjects();";
    }
}

