/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.journal.DiskForceBatcherThread;
import bitronix.tm.journal.TransactionLogCursor;
import bitronix.tm.journal.TransactionLogHeader;
import bitronix.tm.journal.TransactionLogRecord;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogAppender {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogAppender.class);
    public static final int END_RECORD = 2020504642;
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final FileLock lock;
    private final TransactionLogHeader header;
    private long maxFileLength;
    private static DiskForceBatcherThread diskForceBatcherThread;

    public TransactionLogAppender(File file, long maxFileLength) throws IOException {
        this.maxFileLength = maxFileLength;
        this.file = file;
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this.header = new TransactionLogHeader(this.randomAccessFile, maxFileLength);
        this.lock = this.randomAccessFile.getChannel().tryLock(0L, 4L, false);
        if (this.lock == null) {
            throw new IOException("transaction log file " + file.getName() + " is locked. Is another instance already running?");
        }
        this.spawnBatcherThread();
    }

    public TransactionLogHeader getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeLog(TransactionLogRecord tlog) throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            long futureFilePosition = this.getHeader().getPosition() + (long)tlog.calculateTotalRecordSize();
            if (futureFilePosition >= this.maxFileLength) {
                if (log.isDebugEnabled()) {
                    log.debug("log file is full (size would be: " + futureFilePosition + ", max allowed: " + this.maxFileLength + ")");
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("between " + this.getHeader().getPosition() + " and " + futureFilePosition + ", writing " + tlog);
            }
            this.randomAccessFile.writeInt(tlog.getStatus());
            this.randomAccessFile.writeInt(tlog.getRecordLength());
            this.randomAccessFile.writeInt(tlog.getHeaderLength());
            this.randomAccessFile.writeLong(tlog.getTime());
            this.randomAccessFile.writeInt(tlog.getSequenceNumber());
            this.randomAccessFile.writeInt(tlog.getCrc32());
            this.randomAccessFile.writeByte((byte)tlog.getGtrid().getArray().length);
            this.randomAccessFile.write(tlog.getGtrid().getArray());
            this.randomAccessFile.writeInt(tlog.getUniqueNames().size());
            for (String uniqueName : tlog.getUniqueNames()) {
                this.randomAccessFile.writeShort(uniqueName.length());
                this.randomAccessFile.writeBytes(uniqueName);
            }
            this.randomAccessFile.writeInt(tlog.getEndRecord());
            this.getHeader().goAhead(tlog.calculateTotalRecordSize());
            if (log.isDebugEnabled()) {
                log.debug("disk journal appender now at position " + this.getHeader().getPosition());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            this.shutdownBatcherThread();
            this.getHeader().setState((byte)0);
            this.randomAccessFile.getFD().sync();
            this.lock.release();
            this.randomAccessFile.close();
        }
    }

    public TransactionLogCursor getCursor() throws IOException {
        return new TransactionLogCursor(this.file);
    }

    public void force() throws IOException {
        if (!TransactionManagerServices.getConfiguration().isForcedWriteEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("disk forces have been disabled");
            }
            return;
        }
        if (!TransactionManagerServices.getConfiguration().isForceBatchingEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("not batching disk force");
            }
            this.doForce();
        } else {
            diskForceBatcherThread.enqueue(this);
        }
    }

    public String toString() {
        return "a TransactionLogAppender on " + this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForce() throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            if (log.isDebugEnabled()) {
                log.debug("forcing log writing");
            }
            this.randomAccessFile.getFD().sync();
            if (log.isDebugEnabled()) {
                log.debug("done forcing log");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnBatcherThread() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (diskForceBatcherThread != null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("spawning disk force batcher thread");
            }
            diskForceBatcherThread = DiskForceBatcherThread.getInstance();
            if (!TransactionManagerServices.getConfiguration().isForcedWriteEnabled()) {
                log.warn("transaction journal disk syncs have been disabled, transaction logs integrity is not guaranteed !");
                return;
            }
            if (!TransactionManagerServices.getConfiguration().isForceBatchingEnabled()) {
                log.warn("transaction journal disk syncs batching has been disabled, this will seriously impact performance !");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownBatcherThread() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (diskForceBatcherThread == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("requesting disk force batcher thread to shutdown");
            }
            diskForceBatcherThread.setAlive(false);
            diskForceBatcherThread.interrupt();
            do {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("waiting for disk force batcher thread to die");
                    }
                    diskForceBatcherThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (diskForceBatcherThread.isInterrupted());
            if (log.isDebugEnabled()) {
                log.debug("disk force batcher thread has shutdown");
            }
            diskForceBatcherThread = null;
        }
    }
}

