/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jdbc.ConnectionCustomizer;
import bitronix.tm.resource.jdbc.JdbcConnectionHandle;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.PoolingDataSourceMBean;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.ManagementRegistrar;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingDataSource
extends ResourceBean
implements DataSource,
XAResourceProducer,
PoolingDataSourceMBean {
    private static final Logger log = LoggerFactory.getLogger(PoolingDataSource.class);
    private transient XAPool pool;
    private transient XADataSource xaDataSource;
    private transient RecoveryXAResourceHolder recoveryXAResourceHolder;
    private transient JdbcConnectionHandle recoveryConnectionHandle;
    private String testQuery;
    private boolean enableJdbc4ConnectionTest;
    private int preparedStatementCacheSize = 0;
    private String isolationLevel;
    private String cursorHoldability;
    private String localAutoCommit;
    private String jmxName;
    private final List connectionCustomizers = new CopyOnWriteArrayList();

    public synchronized void init() {
        try {
            if (this.pool != null) {
                return;
            }
            this.buildXAPool();
            this.jmxName = "bitronix.tm:type=JDBC,UniqueName=" + ManagementRegistrar.makeValidName(this.getUniqueName());
            ManagementRegistrar.register(this.jmxName, this);
        }
        catch (Exception ex) {
            throw new ResourceConfigurationException("cannot create JDBC datasource named " + this.getUniqueName(), ex);
        }
    }

    private void buildXAPool() throws Exception {
        if (this.pool != null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("building XA pool for " + this.getUniqueName() + " with " + this.getMinPoolSize() + " connection(s)");
        }
        this.pool = new XAPool(this, this);
        this.xaDataSource = (XADataSource)this.pool.getXAFactory();
        try {
            ResourceRegistrar.register(this);
        }
        catch (RecoveryException ex) {
            this.pool = null;
            this.xaDataSource = null;
            throw ex;
        }
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public void setEnableJdbc4ConnectionTest(boolean enableJdbc4ConnectionTest) {
        this.enableJdbc4ConnectionTest = enableJdbc4ConnectionTest;
    }

    public boolean isEnableJdbc4ConnectionTest() {
        return this.enableJdbc4ConnectionTest;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public String getCursorHoldability() {
        return this.cursorHoldability;
    }

    public void setCursorHoldability(String cursorHoldability) {
        this.cursorHoldability = cursorHoldability;
    }

    public String getLocalAutoCommit() {
        return this.localAutoCommit;
    }

    public void setLocalAutoCommit(String localAutoCommit) {
        this.localAutoCommit = localAutoCommit;
    }

    public void addConnectionCustomizer(ConnectionCustomizer connectionCustomizer) {
        this.connectionCustomizers.add(connectionCustomizer);
    }

    public void removeConnectionCustomizer(ConnectionCustomizer connectionCustomizer) {
        Iterator it = this.connectionCustomizers.iterator();
        while (it.hasNext()) {
            ConnectionCustomizer customizer = (ConnectionCustomizer)it.next();
            if (customizer != connectionCustomizer) continue;
            it.remove();
            return;
        }
    }

    void fireOnAcquire(Connection connection) {
        for (int i = 0; i < this.connectionCustomizers.size(); ++i) {
            ConnectionCustomizer connectionCustomizer = (ConnectionCustomizer)this.connectionCustomizers.get(i);
            try {
                connectionCustomizer.onAcquire(connection, this.getUniqueName());
                continue;
            }
            catch (Exception ex) {
                log.warn("ConnectionCustomizer.onAcquire() failed for " + connectionCustomizer, (Throwable)ex);
            }
        }
    }

    void fireOnDestroy(Connection connection) {
        for (int i = 0; i < this.connectionCustomizers.size(); ++i) {
            ConnectionCustomizer connectionCustomizer = (ConnectionCustomizer)this.connectionCustomizers.get(i);
            try {
                connectionCustomizer.onDestroy(connection, this.getUniqueName());
                continue;
            }
            catch (Exception ex) {
                log.warn("ConnectionCustomizer.onDestroy() failed for " + connectionCustomizer, (Throwable)ex);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.isDisabled()) {
            throw new SQLException("JDBC connection pool '" + this.getUniqueName() + "' is disabled, cannot get a connection from it");
        }
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("acquiring connection from " + this);
        }
        if (this.pool == null) {
            if (log.isDebugEnabled()) {
                log.debug("pool is closed, returning null connection");
            }
            return null;
        }
        try {
            InvocationHandler connectionHandle = (InvocationHandler)this.pool.getConnectionHandle();
            if (log.isDebugEnabled()) {
                log.debug("acquired connection from " + this);
            }
            return (Connection)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{Connection.class}, connectionHandle);
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("unable to get a connection from pool of " + this).initCause(ex);
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("JDBC connections are pooled, username and password ignored");
        }
        return this.getConnection();
    }

    public String toString() {
        return "a PoolingDataSource containing " + this.pool;
    }

    public XAResourceHolderState startRecovery() throws RecoveryException {
        this.init();
        if (this.recoveryConnectionHandle != null) {
            throw new RecoveryException("recovery already in progress on " + this);
        }
        try {
            this.recoveryConnectionHandle = (JdbcConnectionHandle)this.pool.getConnectionHandle(false);
            this.recoveryXAResourceHolder = this.recoveryConnectionHandle.getPooledConnection().createRecoveryXAResourceHolder();
            return new XAResourceHolderState(this.recoveryConnectionHandle.getPooledConnection(), this);
        }
        catch (Exception ex) {
            throw new RecoveryException("cannot start recovery on " + this, ex);
        }
    }

    public void endRecovery() throws RecoveryException {
        if (this.recoveryConnectionHandle == null) {
            return;
        }
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("recovery xa resource is being closed: " + this.recoveryXAResourceHolder);
                }
                this.recoveryConnectionHandle.close();
            }
            catch (Exception ex) {
                throw new RecoveryException("error ending recovery on " + this, ex);
            }
            Object var3_1 = null;
            this.recoveryConnectionHandle = null;
            this.recoveryXAResourceHolder = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.recoveryConnectionHandle = null;
            this.recoveryXAResourceHolder = null;
            throw throwable;
        }
    }

    public void setFailed(boolean failed) {
        this.pool.setFailed(failed);
    }

    public boolean isFailed() {
        return this.pool.isFailed();
    }

    public void close() {
        if (this.pool == null) {
            if (log.isDebugEnabled()) {
                log.debug("trying to close already closed PoolingDataSource " + this.getUniqueName());
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("closing " + this);
        }
        this.pool.close();
        this.pool = null;
        this.connectionCustomizers.clear();
        ManagementRegistrar.unregister(this.jmxName);
        this.jmxName = null;
        ResourceRegistrar.unregister(this);
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        if (!(xaFactory instanceof XADataSource)) {
            throw new IllegalArgumentException("class '" + xaFactory.getClass().getName() + "' does not implement " + XADataSource.class.getName());
        }
        XADataSource xads = (XADataSource)xaFactory;
        return new JdbcPooledConnection(this, xads.getXAConnection());
    }

    public XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        return this.pool.findXAResourceHolder(xaResource);
    }

    public Reference getReference() throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("creating new JNDI reference of " + this);
        }
        return new Reference(PoolingDataSource.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return XADataSource.class.equals((Object)iface);
    }

    public Object unwrap(Class iface) throws SQLException {
        if (XADataSource.class.equals((Object)iface)) {
            return this.xaDataSource;
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for interface " + iface.getName());
    }

    public long getInPoolSize() {
        return this.pool.inPoolSize();
    }

    public long getTotalPoolSize() {
        return this.pool.totalPoolSize();
    }

    public void reset() throws Exception {
        this.pool.reset();
    }
}

