/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeImpl;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.internal.runtime.manager.Context;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.Runtime;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class PerProcessInstanceRuntimeManager
extends AbstractRuntimeManager {
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Map<Object, Runtime>> local = new ThreadLocal();
    private Mapper mapper;

    public PerProcessInstanceRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.mapper = environment.getMapper();
    }

    public Runtime getRuntime(Context context) {
        Object contextId = context.getContextId();
        KieSession ksession = null;
        Integer ksessionId = null;
        if (contextId == null) {
            ksession = this.factory.newKieSession();
            ksessionId = ksession.getId();
        } else {
            Runtime localRuntime = this.findLocalRuntime(contextId);
            if (localRuntime != null) {
                return localRuntime;
            }
            ksessionId = this.mapper.findMapping(context);
            if (ksessionId == null) {
                throw new SessionNotFoundException("No session found for context " + context.getContextId());
            }
            ksession = this.factory.findKieSessionById(ksessionId);
        }
        RuntimeImpl runtime = new RuntimeImpl(ksession, this.taskServiceFactory.newTaskService());
        runtime.setManager(this);
        this.registerDisposeCallback(runtime);
        this.registerItems(runtime);
        this.saveLocalRuntime(contextId, runtime);
        ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, runtime));
        return runtime;
    }

    public void disposeRuntime(Runtime runtime) {
        this.removeLocalRuntime(runtime);
        if (runtime instanceof Disposable) {
            ((Disposable)runtime).dispose();
        }
    }

    @Override
    public void close() {
        super.close();
        this.factory.close();
    }

    public boolean validate(Integer ksessionId, Long processInstanceId) {
        Integer mapped = this.mapper.findMapping((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        return mapped == ksessionId;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected Runtime findLocalRuntime(Object processInstanceId) {
        if (processInstanceId == null) {
            return null;
        }
        Map<Object, Runtime> map = local.get();
        if (map == null) {
            return null;
        }
        return map.get(processInstanceId);
    }

    protected void saveLocalRuntime(Object processInstanceId, Runtime runtime) {
        if (processInstanceId == null) {
            return;
        }
        Map<Object, Runtime> map = local.get();
        if (map == null) {
            map = new HashMap<Object, Runtime>();
            local.set(map);
        }
        map.put(processInstanceId, runtime);
    }

    protected void removeLocalRuntime(Runtime runtime) {
        Map<Object, Runtime> map = local.get();
        Object keyToRemove = -1L;
        if (map != null) {
            for (Map.Entry<Object, Runtime> entry : map.entrySet()) {
                if (!runtime.equals(entry.getValue())) continue;
                keyToRemove = entry.getKey();
                break;
            }
            map.remove(keyToRemove);
        }
    }

    private class MaintainMappingListener
    extends DefaultProcessEventListener {
        private Integer ksessionId;
        private Runtime runtime;

        MaintainMappingListener(Integer ksessionId, Runtime runtime) {
            this.ksessionId = ksessionId;
            this.runtime = runtime;
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.removeMapping((Context)ProcessInstanceIdContext.get((Long)event.getProcessInstance().getId()));
            PerProcessInstanceRuntimeManager.this.removeLocalRuntime(this.runtime);
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.saveMapping((Context)ProcessInstanceIdContext.get((Long)event.getProcessInstance().getId()), this.ksessionId);
            PerProcessInstanceRuntimeManager.this.saveLocalRuntime(event.getProcessInstance().getId(), this.runtime);
        }
    }
}

