/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.drools.core.time.TimerService;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.impl.PerProcessInstanceRuntimeManager;
import org.jbpm.runtime.manager.impl.PerRequestRuntimeManager;
import org.jbpm.runtime.manager.impl.SchedulerProvider;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.SingletonRuntimeManager;
import org.jbpm.runtime.manager.impl.factory.InMemorySessionFactory;
import org.jbpm.runtime.manager.impl.factory.JPASessionFactory;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.cdi.qualifier.PerProcessInstance;
import org.kie.internal.runtime.manager.cdi.qualifier.PerRequest;
import org.kie.internal.runtime.manager.cdi.qualifier.Singleton;

@ApplicationScoped
public class RuntimeManagerFactoryImpl
implements RuntimeManagerFactory {
    @Inject
    private Instance<TaskServiceFactory> taskServiceFactoryInjected;

    @Produces
    @Singleton
    public RuntimeManager newSingletonRuntimeManager(@Singleton RuntimeEnvironment environment) {
        return this.newSingletonRuntimeManager(environment, "default-singleton");
    }

    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        SingletonRuntimeManager manager = new SingletonRuntimeManager(environment, factory, taskServiceFactory, identifier);
        this.initTimerService(environment, manager);
        manager.init();
        return manager;
    }

    @Produces
    @PerRequest
    public RuntimeManager newPerRequestRuntimeManager(@PerRequest RuntimeEnvironment environment) {
        return this.newPerRequestRuntimeManager(environment, "default-per-request");
    }

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        PerRequestRuntimeManager manager = new PerRequestRuntimeManager(environment, factory, taskServiceFactory, identifier);
        this.initTimerService(environment, manager);
        return manager;
    }

    @Produces
    @PerProcessInstance
    public RuntimeManager newPerProcessInstanceRuntimeManager(@PerProcessInstance RuntimeEnvironment environment) {
        return this.newPerProcessInstanceRuntimeManager(environment, "default-per-pinstance");
    }

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        PerProcessInstanceRuntimeManager manager = new PerProcessInstanceRuntimeManager(environment, factory, taskServiceFactory, identifier);
        this.initTimerService(environment, manager);
        return manager;
    }

    protected SessionFactory getSessionFactory(RuntimeEnvironment environment) {
        Object factory = null;
        factory = environment.usePersistence() ? new JPASessionFactory(environment) : new InMemorySessionFactory(environment);
        return factory;
    }

    public TaskServiceFactory getTaskServiceFactory(RuntimeEnvironment environment) {
        TaskServiceFactory taskServiceFactory = null;
        try {
            taskServiceFactory = (TaskServiceFactory)this.taskServiceFactoryInjected.get();
        }
        catch (Exception e) {
            taskServiceFactory = new LocalTaskServiceFactory(environment);
        }
        return taskServiceFactory;
    }

    protected void initTimerService(RuntimeEnvironment environment, RuntimeManager manager) {
        GlobalSchedulerService schedulerService;
        if (environment instanceof SchedulerProvider && (schedulerService = ((SchedulerProvider)environment).getSchedulerService()) != null) {
            GlobalTimerService globalTs = new GlobalTimerService(manager, schedulerService);
            String timerServiceId = manager.getIdentifier() + "-timerServiceId";
            TimerServiceRegistry.getInstance().registerTimerService(timerServiceId, (TimerService)globalTs);
            ((SimpleRuntimeEnvironment)environment).addToConfiguration("drools.timerService", "new org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate(\"" + timerServiceId + "\")");
        }
    }
}

