/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import java.util.Map;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.kie.api.definition.process.NodeContainer;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubProcessHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        CompositeContextNode result = new CompositeContextNode();
        String eventSubprocessAttribute = attrs.getValue("triggeredByEvent");
        if (eventSubprocessAttribute != null && Boolean.parseBoolean(eventSubprocessAttribute)) {
            result = new EventSubProcessNode();
        }
        VariableScope variableScope = new VariableScope();
        result.addContext((Context)variableScope);
        result.setDefaultContext((Context)variableScope);
        return result;
    }

    public Class generateNodeFor() {
        return CompositeContextNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        boolean found = false;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            forEachNode.setName(node.getName());
            for (org.kie.api.definition.process.Node subNode : ((CompositeContextNode)node).getNodes()) {
                forEachNode.addNode(subNode);
            }
            forEachNode.setMetaData("UniqueId", ((CompositeContextNode)node).getMetaData("UniqueId"));
            forEachNode.setMetaData("BPMN.Connections", ((CompositeContextNode)node).getMetaData("BPMN.Connections"));
            VariableScope v = (VariableScope)((CompositeContextNode)node).getDefaultContext("VariableScope");
            ((VariableScope)((CompositeContextNode)forEachNode.internalGetNode(2L)).getDefaultContext("VariableScope")).setVariables(v.getVariables());
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser);
            found = true;
            break;
        }
        if (!found) {
            this.handleCompositeContextNode(node, element, uri, localName, parser);
        }
        org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        return node;
    }

    protected void handleCompositeContextNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        CompositeContextNode compositeNode = (CompositeContextNode)node;
        List connections = (List)compositeNode.getMetaData("BPMN.Connections");
        ProcessHandler.linkConnections((NodeContainer)compositeNode, connections);
        List throwLinks = (List)compositeNode.getMetaData("BPMN.ThrowLinks");
        ProcessHandler.linkIntermediateLinks((NodeContainer)compositeNode, throwLinks);
        ProcessHandler.linkBoundaryEvents((NodeContainer)compositeNode);
    }

    protected void handleForEachNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, forEachNode);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
        List connections = (List)forEachNode.getMetaData("BPMN.Connections");
        ProcessHandler.linkConnections((NodeContainer)forEachNode, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)forEachNode);
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, ForEachNode forEachNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String inputVariable = subNode.getTextContent();
        if (inputVariable != null && inputVariable.trim().length() > 0) {
            forEachNode.setCollectionExpression(inputVariable);
        }
    }

    protected void readMultiInstanceLoopCharacteristics(org.w3c.dom.Node xmlNode, ForEachNode forEachNode, ExtensibleXmlParser parser) {
        for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
            String outputDataRef;
            String outputDataName;
            ItemDefinition itemDefinition;
            Map itemDefinitions;
            ObjectDataType dataType;
            String itemSubjectRef;
            String variableName;
            String nodeName = subNode.getNodeName();
            if ("inputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("id");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                if (itemDefinitions != null && (itemDefinition = (ItemDefinition)itemDefinitions.get(itemSubjectRef)) != null) {
                    dataType = new ObjectDataType(itemDefinition.getStructureRef());
                }
                if (dataType == null) {
                    dataType = new ObjectDataType("java.lang.Object");
                }
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setVariable(variableName, (DataType)dataType);
                continue;
            }
            if ("outputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("id");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                if (itemDefinitions != null && (itemDefinition = (ItemDefinition)itemDefinitions.get(itemSubjectRef)) != null) {
                    dataType = new ObjectDataType(itemDefinition.getStructureRef());
                }
                if (dataType == null) {
                    dataType = new ObjectDataType("java.lang.Object");
                }
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setOutputVariable(variableName, (DataType)dataType);
                continue;
            }
            if (!"loopDataOutputRef".equals(nodeName) || (outputDataName = (String)this.dataOutputs.get(outputDataRef = ((Element)subNode).getTextContent())) == null || outputDataName.trim().length() <= 0) continue;
            forEachNode.setOutputCollectionExpression(outputDataName);
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

