/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.drools.core.process.core.Work;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.TaskHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserTaskHandler
extends TaskHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new HumanTaskNode();
    }

    public Class generateNodeFor() {
        return HumanTaskNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        Work work = humanTaskNode.getWork();
        work.setName("Human Task");
        HashMap<String, String> dataInputs = new HashMap<String, String>();
        HashMap<String, String> dataOutputs = new HashMap<String, String>();
        ArrayList<String> owners = new ArrayList<String>();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String owner;
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, dataInputs, dataOutputs);
                continue;
            }
            if (!"potentialOwner".equals(nodeName) || (owner = this.readPotentialOwner(xmlNode, humanTaskNode)) == null) continue;
            owners.add(owner);
        }
        if (owners.size() > 0) {
            String owner = (String)owners.get(0);
            for (int i = 1; i < owners.size(); ++i) {
                owner = owner + "," + (String)owners.get(i);
            }
            humanTaskNode.getWork().setParameter("ActorId", (Object)owner);
        }
    }

    protected String readPotentialOwner(org.w3c.dom.Node xmlNode, HumanTaskNode humanTaskNode) {
        org.w3c.dom.Node node = xmlNode.getFirstChild();
        if (node != null && (node = node.getFirstChild()) != null && (node = node.getFirstChild()) != null) {
            return node.getTextContent();
        }
        return null;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        this.writeNode("userTask", (Node)humanTaskNode, xmlDump, metaDataType);
        xmlDump.append(">" + EOL);
        this.writeScripts((ExtendedNodeImpl)humanTaskNode, xmlDump);
        this.writeIO((WorkItemNode)humanTaskNode, xmlDump);
        String ownerString = (String)humanTaskNode.getWork().getParameter("ActorId");
        if (ownerString != null) {
            String[] owners;
            for (String owner : owners = ownerString.split(",")) {
                xmlDump.append("      <potentialOwner>" + EOL + "        <resourceAssignmentExpression>" + EOL + "          <formalExpression>" + owner + "</formalExpression>" + EOL + "        </resourceAssignmentExpression>" + EOL + "      </potentialOwner>" + EOL);
            }
        }
        this.endNode("userTask", xmlDump);
    }

    protected void writeIO(WorkItemNode workItemNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL + "        <assignment>" + EOL + "          <from xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)entry.getValue().toString()) + "</from>" + EOL + "          <to xsi:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</to>" + EOL + "        </assignment>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

