/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBasedResolver {
    private ConcurrentMap<String, Set<Bean<?>>> resolvedNames;

    public NameBasedResolver(BeanManagerImpl manager, Iterable<? extends Bean<?>> allBeans) {
        this.resolvedNames = new MapMaker().makeComputingMap((Function)new NameToBeanSet(manager, allBeans));
    }

    public void clear() {
        this.resolvedNames.clear();
    }

    public Set<Bean<?>> resolve(String name) {
        return (Set)this.resolvedNames.get(name);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameToBeanSet
    implements Function<String, Set<Bean<?>>> {
        private final BeanManagerImpl beanManager;
        private final Iterable<? extends Bean<?>> allBeans;

        private NameToBeanSet(BeanManagerImpl beanManager, Iterable<? extends Bean<?>> allBeans) {
            this.beanManager = beanManager;
            this.allBeans = allBeans;
        }

        public Set<Bean<?>> apply(String from) {
            HashSet matchedBeans = new HashSet();
            for (Bean<?> bean : this.allBeans) {
                if ((bean.getName() != null || from != null) && (bean.getName() == null || !bean.getName().equals(from))) continue;
                matchedBeans.add(bean);
            }
            return ImmutableSet.copyOf(Beans.removeDisabledAndSpecializedBeans(matchedBeans, this.beanManager));
        }
    }
}

