/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.process.audit.event.AuditEvent;

@Entity
@SequenceGenerator(name="variableInstanceLogIdSeq", sequenceName="VAR_INST_LOG_ID_SEQ", allocationSize=1)
public class VariableInstanceLog
implements Serializable,
AuditEvent {
    private static final long serialVersionUID = 510L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="variableInstanceLogIdSeq")
    private long id;
    private long processInstanceId;
    private String processId;
    private String variableInstanceId;
    private String variableId;
    private String value;
    private String oldValue;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="log_date")
    private Date date;
    private String domainId;

    VariableInstanceLog() {
    }

    public VariableInstanceLog(long processInstanceId, String processId, String variableInstanceId, String variableId, String value, String oldValue) {
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.variableInstanceId = variableInstanceId;
        this.variableId = variableId;
        this.setValue(value);
        this.setOldValue(oldValue);
        this.date = new Date();
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public void setVariableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null && value.length() > 255) {
            value = value.substring(0, 255);
        }
        this.value = value;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        if (oldValue != null && oldValue.length() > 255) {
            oldValue = oldValue.substring(0, 255);
        }
        this.oldValue = oldValue;
    }

    public Date getDate() {
        return this.date;
    }

    void setDate(Date date) {
        this.date = date;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String toString() {
        return "Change variable '" + this.processId + "#" + this.variableId + "' to '" + this.value + "' [" + this.processInstanceId + "#" + this.variableInstanceId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (int)this.id;
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (int)this.processInstanceId;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.oldValue == null ? 0 : this.oldValue.hashCode());
        result = 31 * result + (this.variableId == null ? 0 : this.variableId.hashCode());
        result = 31 * result + (this.variableInstanceId == null ? 0 : this.variableInstanceId.hashCode());
        result = 31 * result + (this.domainId == null ? 0 : this.domainId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableInstanceLog other = (VariableInstanceLog)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.oldValue == null ? other.oldValue != null : !this.oldValue.equals(other.oldValue)) {
            return false;
        }
        if (this.variableId == null ? other.variableId != null : !this.variableId.equals(other.variableId)) {
            return false;
        }
        if (this.variableInstanceId == null ? other.variableInstanceId != null : !this.variableInstanceId.equals(other.variableInstanceId)) {
            return false;
        }
        return !(this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId));
    }
}

