/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.annotations.External;
import org.jbpm.services.task.events.AfterTaskCompletedEvent;
import org.jbpm.services.task.events.AfterTaskFailedEvent;
import org.jbpm.services.task.events.AfterTaskSkippedEvent;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.services.task.wih.RuntimeFinder;
import org.jbpm.shared.services.impl.events.JbpmServicesEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.runtime.manager.Context;
import org.kie.internal.runtime.manager.Runtime;
import org.kie.internal.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.model.Content;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@External
@Transactional
public class ExternalTaskEventListener
extends JbpmServicesEventListener<Task>
implements TaskLifeCycleEventListener {
    private RuntimeManager runtimeManager;
    private Map<Integer, ClassLoader> classLoaders = new HashMap<Integer, ClassLoader>();
    private Map<String, RuntimeManager> mappedManagers = new ConcurrentHashMap<String, RuntimeManager>();
    private RuntimeFinder finder;
    private static final Logger logger = LoggerFactory.getLogger(ExternalTaskEventListener.class);

    public void addClassLoader(Integer sessionId, ClassLoader cl) {
        this.classLoaders.put(sessionId, cl);
    }

    public RuntimeManager getRuntimeManager() {
        return this.runtimeManager;
    }

    public void setRuntimeManager(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public void processTaskState(Task task) {
        long workItemId = task.getTaskData().getWorkItemId();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        Runtime runtime = this.getManager(task).getRuntime((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession session = runtime.getKieSession();
        if (task.getTaskData().getStatus() == Status.Completed) {
            String userId = task.getTaskData().getActualOwner().getId();
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("ActorId", userId);
            long contentId = task.getTaskData().getOutputContentId();
            if (contentId != -1L) {
                Content content = runtime.getTaskService().getContentById(contentId);
                Object result = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)session.getEnvironment(), (ClassLoader)this.classLoaders.get(session.getId()));
                results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                session.getWorkItemManager().completeWorkItem(task.getTaskData().getWorkItemId(), results);
            } else {
                session.getWorkItemManager().completeWorkItem(workItemId, results);
            }
        } else {
            session.getWorkItemManager().abortWorkItem(workItemId);
        }
    }

    public void afterTaskActivatedEvent(Task ti) {
    }

    public void afterTaskClaimedEvent(Task ti) {
    }

    public void afterTaskSkippedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskSkippedEvent Task task) {
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskStartedEvent(Task ti) {
    }

    public void afterTaskStoppedEvent(Task ti) {
    }

    public void afterTaskCompletedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskCompletedEvent Task task) {
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        Runtime runtime = this.getManager(task).getRuntime((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession session = runtime.getKieSession();
        if (session != null) {
            logger.debug(">> I've recieved an event for a known session (" + task.getTaskData().getProcessSessionId() + ")");
            this.processTaskState(task);
        } else {
            logger.error("EE: I've recieved an event but the session is not known by this handler ( " + task.getTaskData().getProcessSessionId() + ")");
        }
    }

    public void afterTaskFailedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskFailedEvent Task task) {
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskAddedEvent(Task ti) {
    }

    public void afterTaskExitedEvent(Task ti) {
    }

    public RuntimeManager getManager(Task task) {
        if (this.runtimeManager != null) {
            return this.runtimeManager;
        }
        if (this.mappedManagers.size() == 1) {
            return this.mappedManagers.values().iterator().next();
        }
        String name = this.finder.findName(task.getTaskData().getProcessInstanceId());
        return this.mappedManagers.get(name);
    }

    public Map<String, RuntimeManager> getMappedManagers() {
        return this.mappedManagers;
    }

    public void setMappedManagers(Map<String, RuntimeManager> mappedManagers) {
        this.mappedManagers = mappedManagers;
    }

    public void addMappedManger(String name, RuntimeManager manager) {
        this.mappedManagers.put(name, manager);
    }

    public RuntimeFinder getFinder() {
        return this.finder;
    }

    public void setFinder(RuntimeFinder finder) {
        this.finder = finder;
    }
}

