/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.task.api.model.OrganizationalEntity;
import org.kie.internal.task.api.model.PeopleAssignments;
import org.kie.internal.task.api.model.Task;
import org.kie.internal.task.api.model.TaskData;
import org.kie.internal.task.api.model.User;

public class PeopleAssignmentHelper {
    public static final String ACTOR_ID = "ActorId";
    public static final String GROUP_ID = "GroupId";
    public static final String BUSINESSADMINISTRATOR_ID = "BusinessAdministratorId";
    public static final String TASKSTAKEHOLDER_ID = "TaskStakeholderId";
    public static final String EXCLUDED_OWNER_ID = "ExcludedOwnerId";
    public static final String RECIPIENT_ID = "RecipientId";

    public void handlePeopleAssignments(WorkItem workItem, Task task, TaskData taskData) {
        PeopleAssignments peopleAssignments = this.getNullSafePeopleAssignments(task);
        this.assignActors(workItem, peopleAssignments, taskData);
        this.assignGroups(workItem, peopleAssignments);
        this.assignBusinessAdministrators(workItem, peopleAssignments);
        this.assignTaskStakeholders(workItem, peopleAssignments);
        this.assignExcludedOwners(workItem, peopleAssignments);
        this.assignRecipients(workItem, peopleAssignments);
        task.setPeopleAssignments(peopleAssignments);
    }

    protected void assignActors(WorkItem workItem, PeopleAssignments peopleAssignments, TaskData taskData) {
        String actorIds = (String)workItem.getParameter(ACTOR_ID);
        List potentialOwners = peopleAssignments.getPotentialOwners();
        this.processPeopleAssignments(actorIds, potentialOwners, true);
        if (potentialOwners.size() > 0 && taskData.getCreatedBy() == null) {
            OrganizationalEntity firstPotentialOwner = (OrganizationalEntity)potentialOwners.get(0);
            taskData.setCreatedBy((User)((UserImpl)firstPotentialOwner));
        }
    }

    protected void assignGroups(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String groupIds = (String)workItem.getParameter(GROUP_ID);
        List potentialOwners = peopleAssignments.getPotentialOwners();
        this.processPeopleAssignments(groupIds, potentialOwners, false);
    }

    protected void assignBusinessAdministrators(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String businessAdministratorIds = (String)workItem.getParameter(BUSINESSADMINISTRATOR_ID);
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        UserImpl administrator = new UserImpl("Administrator");
        businessAdministrators.add(administrator);
        this.processPeopleAssignments(businessAdministratorIds, businessAdministrators, true);
    }

    protected void assignTaskStakeholders(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String taskStakehodlerIds = (String)workItem.getParameter(TASKSTAKEHOLDER_ID);
        List taskStakeholders = peopleAssignments.getTaskStakeholders();
        this.processPeopleAssignments(taskStakehodlerIds, taskStakeholders, true);
    }

    protected void assignExcludedOwners(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String excludedOwnerIds = (String)workItem.getParameter(EXCLUDED_OWNER_ID);
        List excludedOwners = peopleAssignments.getExcludedOwners();
        this.processPeopleAssignments(excludedOwnerIds, excludedOwners, true);
    }

    protected void assignRecipients(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String recipientIds = (String)workItem.getParameter(RECIPIENT_ID);
        List recipients = peopleAssignments.getRecipients();
        this.processPeopleAssignments(recipientIds, recipients, true);
    }

    protected void processPeopleAssignments(String peopleAssignmentIds, List<OrganizationalEntity> organizationalEntities, boolean user) {
        if (peopleAssignmentIds != null && peopleAssignmentIds.trim().length() > 0) {
            String[] ids;
            for (String id : ids = peopleAssignmentIds.split(",")) {
                id = id.trim();
                boolean exists = false;
                for (OrganizationalEntity orgEntity : organizationalEntities) {
                    if (!orgEntity.getId().equals(id)) continue;
                    exists = true;
                }
                if (exists) continue;
                Object organizationalEntity = null;
                organizationalEntity = user ? new UserImpl(id) : new GroupImpl(id);
                organizationalEntities.add((OrganizationalEntity)organizationalEntity);
            }
        }
    }

    protected PeopleAssignments getNullSafePeopleAssignments(Task task) {
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        if (peopleAssignments == null) {
            peopleAssignments = new PeopleAssignmentsImpl();
            peopleAssignments.setPotentialOwners(new ArrayList());
            peopleAssignments.setBusinessAdministrators(new ArrayList());
            peopleAssignments.setExcludedOwners(new ArrayList());
            peopleAssignments.setRecipients(new ArrayList());
            peopleAssignments.setTaskStakeholders(new ArrayList());
        }
        return peopleAssignments;
    }
}

