/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.hibernate.HibernateManagedSessionProxyHandler;
import org.jboss.seam.persistence.hibernate.SeamManagedHibernateSessionCreated;
import org.jboss.solder.bean.ContextualLifecycle;
import org.jboss.solder.literal.DefaultLiteral;
import org.jboss.solder.logging.Logger;

public class HibernateManagedSessionBeanLifecycle
implements ContextualLifecycle<Session> {
    private static final Logger log = Logger.getLogger(HibernateManagedSessionBeanLifecycle.class);
    private final Class<?> proxyClass;
    private final Constructor<?> proxyConstructor;
    private HibernatePersistenceProvider persistenceProvider = new HibernatePersistenceProvider();
    private PersistenceContexts persistenceContexts;
    protected final Annotation[] qualifiers;
    protected final BeanManager manager;
    private SessionFactory sessionFactory;

    public HibernateManagedSessionBeanLifecycle(Set<Annotation> qualifiers, ClassLoader loader, BeanManager manager) {
        this.manager = manager;
        Set<Class<?>> additionalinterfaces = this.persistenceProvider.getAdditionalSessionInterfaces();
        Class[] interfaces = new Class[additionalinterfaces.size() + 3];
        int count = 0;
        for (Class<?> i : additionalinterfaces) {
            interfaces[count++] = i;
        }
        interfaces[count++] = Session.class;
        interfaces[count++] = Serializable.class;
        interfaces[count++] = ManagedPersistenceContext.class;
        this.proxyClass = Proxy.getProxyClass(loader, interfaces);
        try {
            this.proxyConstructor = this.proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.qualifiers = new Annotation[qualifiers.size()];
        int i = 0;
        for (Annotation a : qualifiers) {
            this.qualifiers[i++] = a;
        }
    }

    public Session create(Bean<Session> bean, CreationalContext<Session> arg0) {
        try {
            SessionFactory sf = this.getSessionFactory();
            Session session = sf.openSession();
            session = (Session)this.persistenceProvider.proxyDelegate(session);
            HibernateManagedSessionProxyHandler handler = new HibernateManagedSessionProxyHandler(session, this.manager, bean.getQualifiers(), this.persistenceProvider, this.manager);
            Session proxy = (Session)this.proxyConstructor.newInstance(handler);
            try {
                ((ManagedPersistenceContext)proxy).changeFlushMode(this.getPersistenceContexts().getFlushMode());
            }
            catch (ContextNotActiveException e) {
                // empty catch block
            }
            this.manager.fireEvent((Object)new SeamManagedHibernateSessionCreated(proxy), this.qualifiers);
            return proxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy(Bean<Session> bean, Session session, CreationalContext<Session> arg1) {
        ((ManagedPersistenceContext)session).closeAfterTransaction();
        arg1.release();
        try {
            this.getPersistenceContexts().untouch((ManagedPersistenceContext)session);
        }
        catch (ContextNotActiveException e) {
            log.debug((Object)"Could not untouch PersistenceContext as conversation scope not active");
        }
    }

    private PersistenceContexts getPersistenceContexts() {
        if (this.persistenceContexts == null) {
            Bean bean = this.manager.resolve(this.manager.getBeans(PersistenceContexts.class, new Annotation[]{DefaultLiteral.INSTANCE}));
            if (bean == null) {
                throw new RuntimeException("Could not find PersistenceContexts bean");
            }
            CreationalContext ctx = this.manager.createCreationalContext((Contextual)bean);
            this.persistenceContexts = (PersistenceContexts)this.manager.getReference(bean, PersistenceContexts.class, ctx);
        }
        return this.persistenceContexts;
    }

    protected SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            Bean bean = this.manager.resolve(this.manager.getBeans(SessionFactory.class, this.qualifiers));
            if (bean == null) {
                throw new RuntimeException("Could not find SessionFactory bean with qualifiers" + this.qualifiers);
            }
            CreationalContext ctx = this.manager.createCreationalContext((Contextual)bean);
            this.sessionFactory = (SessionFactory)this.manager.getReference(bean, SessionFactory.class, ctx);
        }
        return this.sessionFactory;
    }
}

