/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.droolsjbpm.services.api.DomainManagerService;
import org.droolsjbpm.services.api.IdentityProvider;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.domain.entities.Domain;
import org.droolsjbpm.services.domain.entities.Organization;
import org.droolsjbpm.services.domain.entities.RuntimeId;
import org.droolsjbpm.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.DefaultRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.cdi.InjectableRegisterableItemsFactory;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.io.ResourceType;
import org.kie.commons.java.nio.file.Path;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerFactory;

@Transactional
@ApplicationScoped
public class DomainManagerServiceImpl
implements DomainManagerService {
    @Inject
    private BeanManager beanManager;
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private FileService fs;
    @Inject
    private RuntimeManagerFactory managerFactory;
    @Inject
    private EntityManagerFactory emf;
    @Inject
    private BPMN2DataService bpmn2Service;
    private Map<String, RuntimeManager> domainsMap = new HashMap<String, RuntimeManager>();
    private Map<String, List<String>> processDefinitionNamesByDomain = new HashMap<String, List<String>>();
    @Inject
    private IdentityProvider identityProvider;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    public List<Domain> getAllDomains() {
        return (List)this.pm.queryStringInTransaction("select d from Domain d");
    }

    @Override
    public List<Domain> getAllDomainsByOrganization(long organizationId) {
        return (List)this.pm.queryStringWithParametersInTransaction("select d from Domain d where d.organization.id = :organizationId", (Map)this.pm.addParametersToMap(new Object[]{"organizationId", organizationId}));
    }

    @Override
    public Domain getDomainByName(String domainName) {
        return (Domain)((List)this.pm.queryStringWithParametersInTransaction("select d from Domain d where d.name = :domainName", (Map)this.pm.addParametersToMap(new Object[]{"domainName", domainName}))).get(0);
    }

    @Override
    public long storeDomain(Domain domain) {
        this.pm.persist((Object)domain);
        return domain.getId();
    }

    @Override
    public void removeDomain(long domainId) {
        Domain domain = (Domain)this.pm.find(Domain.class, (Object)domainId);
        this.pm.remove((Object)domain);
    }

    @Override
    public List<Organization> getAllOrganizations() {
        return (List)this.pm.queryStringInTransaction("select o from Organization o");
    }

    @Override
    public long storeOrganization(Organization organization) {
        if (organization.getDomains() == null || organization.getDomains().isEmpty()) {
            Map<String, Domain> domains = this.discoverDomains(organization, "processes");
            organization.setDomains(new ArrayList<Domain>(domains.values()));
        }
        this.pm.persist((Object)organization);
        return organization.getId();
    }

    @Override
    public void removeOrganization(long organizationId) {
        Organization o = (Organization)this.pm.find(Organization.class, (Object)organizationId);
        this.pm.remove((Object)o);
    }

    @Override
    public Organization getOrganizationById(long organizationId) {
        return (Organization)this.pm.find(Organization.class, (Object)organizationId);
    }

    @Override
    public Domain getDomainById(long domainId) {
        return (Domain)this.pm.find(Domain.class, (Object)domainId);
    }

    @Override
    public void initOrganization(long organizationId) {
        Organization org = this.getOrganizationById(organizationId);
        Map<String, Domain> discovered = this.discoverDomains(org, "processes");
        for (Domain d : org.getDomains()) {
            this.initDomain(d.getId());
            discovered.remove(d.getName());
        }
        if (!discovered.isEmpty()) {
            ArrayList<Domain> domains = new ArrayList<Domain>(discovered.values());
            for (Domain d : domains) {
                this.pm.persist((Object)d);
                this.initDomain(d.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDomain(long domainId) {
        Domain d = this.getDomainById(domainId);
        this.fs.fetchChanges();
        if (d != null) {
            ArrayList<ProcessDesc> loadedProcesses = new ArrayList<ProcessDesc>();
            for (RuntimeId r : d.getRuntimes()) {
                String reference = r.getReference();
                DefaultRuntimeEnvironment environment = new DefaultRuntimeEnvironment(this.emf);
                UserTransaction ut = null;
                try {
                    ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                }
                catch (Exception ex) {
                    try {
                        ut = (UserTransaction)InitialContext.doLookup(System.getProperty("jbpm.ut.jndi.lookup", "java:jboss/UserTransaction"));
                        environment.addToEnvironment("org.kie.transaction.Transaction", (Object)ut);
                    }
                    catch (Exception e1) {
                        throw new RuntimeException("Cannot find UserTransaction", e1);
                    }
                }
                AbstractAuditLogger auditLogger = AuditLoggerFactory.newJPAInstance((EntityManagerFactory)this.emf);
                ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
                auditEventBuilder.setIdentityProvider(this.identityProvider);
                auditEventBuilder.setDomain(d);
                auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
                environment.setRegisterableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger));
                Iterable loadProcessFiles = null;
                try {
                    loadProcessFiles = this.fs.loadFilesByType(reference, ".+bpmn[2]?$");
                }
                catch (FileException ex) {
                    Logger.getLogger(DomainManagerServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (Path p : loadProcessFiles) {
                    String processString = "";
                    try {
                        processString = new String(this.fs.loadFile(p));
                        environment.addAsset(ResourceFactory.newByteArrayResource((byte[])processString.getBytes()), ResourceType.BPMN2);
                        ProcessDesc process = this.bpmn2Service.findProcessId(processString);
                        if (process == null) continue;
                        process.setDomainName(d.getName());
                        process.setOriginalPath(p.toString());
                        loadedProcesses.add(process);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DomainManagerServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (loadedProcesses.isEmpty()) continue;
                Map<String, RuntimeManager> map = this.domainsMap;
                synchronized (map) {
                    RuntimeManager manager;
                    if (this.domainsMap.containsKey(d.getName())) {
                        manager = this.domainsMap.remove(d.getName());
                        manager.close();
                        Collection<ProcessDesc> existingProcesses = this.getProcessesByDomainName(d.getName());
                        for (ProcessDesc toDelete : existingProcesses) {
                            this.pm.remove((Object)toDelete);
                        }
                    }
                    for (ProcessDesc process : loadedProcesses) {
                        this.pm.persist((Object)process);
                    }
                    manager = this.managerFactory.newSingletonRuntimeManager((RuntimeEnvironment)environment, d.getName());
                    this.domainsMap.put(d.getName(), manager);
                }
            }
        }
    }

    protected void addProcessDefinitionToDomain(String domainName, String processId) {
        if (this.processDefinitionNamesByDomain.get(domainName) == null) {
            this.processDefinitionNamesByDomain.put(domainName, new ArrayList());
        }
        this.processDefinitionNamesByDomain.get(domainName).add(processId);
    }

    protected Map<String, Domain> discoverDomains(Organization organization, String location) {
        Iterable domainDirs = this.fs.listDirectories(location);
        HashMap<String, Domain> domains = new HashMap<String, Domain>();
        for (Path domainDir : domainDirs) {
            String dirName = domainDir.getFileName().toString();
            Domain domain = new Domain();
            domain.setName(dirName + " Domain");
            ArrayList<RuntimeId> runtimesRelease = new ArrayList<RuntimeId>();
            RuntimeId releaseRuntime = new RuntimeId();
            releaseRuntime.setName(dirName + " Runtime");
            releaseRuntime.setReference(location + "/" + dirName + "/");
            releaseRuntime.setType("Folder/Runtime Manager(Singleton)");
            runtimesRelease.add(releaseRuntime);
            domain.setRuntimes(runtimesRelease);
            domain.setOrganization(organization);
            domains.put(domain.getName(), domain);
        }
        return domains;
    }

    @Override
    public Collection<ProcessDesc> getProcessesByDomainName(String domainName) {
        List processes = (List)this.pm.queryStringWithParametersInTransaction("select pd from ProcessDesc pd where pd.domainName=:domainName GROUP BY pd.id ORDER BY pd.dataTimeStamp DESC", (Map)this.pm.addParametersToMap(new Object[]{"domainName", domainName}));
        return processes;
    }

    @Override
    public Map<String, RuntimeManager> getDomainsMap() {
        return this.domainsMap;
    }

    @Override
    public RuntimeManager getRuntimesByDomain(String domainName) {
        return this.domainsMap.get(domainName);
    }

    public void clearDomains() {
        this.domainsMap.clear();
    }
}

