/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.audit;

import org.droolsjbpm.services.api.IdentityProvider;
import org.droolsjbpm.services.domain.entities.Domain;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.event.AuditEvent;
import org.jbpm.process.audit.event.DefaultAuditEventBuilderImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;

public class ServicesAwareAuditEventBuilder
extends DefaultAuditEventBuilderImpl {
    private IdentityProvider identityProvider;
    private Domain domain;

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public AuditEvent buildEvent(ProcessStartedEvent pse) {
        ProcessInstanceLog log = (ProcessInstanceLog)super.buildEvent(pse);
        log.setIdentity(this.identityProvider.getName());
        log.setDomainId(this.domain.getName());
        return log;
    }

    public AuditEvent buildEvent(ProcessCompletedEvent pce, Object log) {
        ProcessInstanceLog instanceLog = (ProcessInstanceLog)super.buildEvent(pce, log);
        instanceLog.setIdentity(this.identityProvider.getName());
        instanceLog.setDomainId(this.domain.getName());
        return instanceLog;
    }

    public AuditEvent buildEvent(ProcessNodeTriggeredEvent pnte) {
        NodeInstanceLog nodeInstanceLog = (NodeInstanceLog)super.buildEvent(pnte);
        nodeInstanceLog.setDomainId(this.domain.getName());
        return nodeInstanceLog;
    }

    public AuditEvent buildEvent(ProcessNodeLeftEvent pnle, Object log) {
        NodeInstanceLog nodeInstanceLog = (NodeInstanceLog)super.buildEvent(pnle, log);
        nodeInstanceLog.setDomainId(this.domain.getName());
        return nodeInstanceLog;
    }

    public AuditEvent buildEvent(ProcessVariableChangedEvent pvce) {
        VariableInstanceLog variableLog = (VariableInstanceLog)super.buildEvent(pvce);
        variableLog.setDomainId(this.domain.getName());
        return variableLog;
    }
}

