/*
 * Decompiled with CFR 0.152.
 */
package org.droolsjbpm.services.impl.event.listeners;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import org.droolsjbpm.services.impl.event.NodeInstanceLeftEvent;
import org.droolsjbpm.services.impl.event.NodeInstanceTriggeredEvent;
import org.droolsjbpm.services.impl.event.ProcessInstanceCompletedEvent;
import org.droolsjbpm.services.impl.event.ProcessInstanceStartedEvent;
import org.jboss.seam.transaction.Transactional;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;

@ApplicationScoped
@Transactional
public class CDIRuleAwareProcessEventListener
implements ProcessEventListener {
    public void beforeProcessStarted(ProcessStartedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().update(handle, (Object)event.getProcessInstance());
        } else {
            event.getKieRuntime().insert((Object)event.getProcessInstance());
        }
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)new ProcessInstanceStartedEvent(event));
        ((KieSession)event.getKieRuntime()).fireAllRules();
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)new ProcessInstanceCompletedEvent(event));
        ((KieSession)event.getKieRuntime()).fireAllRules();
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().retract(handle);
        }
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)new NodeInstanceTriggeredEvent(event));
        ((KieSession)event.getKieRuntime()).fireAllRules();
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        event.getKieRuntime().getEntryPoint("process-events").insert((Object)new NodeInstanceLeftEvent(event));
        ((KieSession)event.getKieRuntime()).fireAllRules();
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(event.getProcessInstance().getId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().update(handle, (Object)event.getProcessInstance());
        } else {
            event.getKieRuntime().insert((Object)event.getProcessInstance());
        }
    }

    protected FactHandle getProcessInstanceFactHandle(final Long processInstanceId, KieRuntime kruntime) {
        Collection factHandles = kruntime.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return WorkflowProcessInstance.class.isAssignableFrom(object.getClass()) && ((WorkflowProcessInstance)object).getId() == processInstanceId.longValue();
            }
        });
        if (factHandles != null && factHandles.size() > 0) {
            FactHandle handle = (FactHandle)factHandles.iterator().next();
            return handle;
        }
        return null;
    }
}

