/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskFailedEvent;
import org.jbpm.services.task.events.BeforeTaskFailedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.FaultDataImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.kie.internal.task.api.model.User;

@Transactional
public class FailTaskCommand<Void>
extends TaskCommand {
    private Map<String, Object> data;

    public FailTaskCommand(long taskId, String userId, Map<String, Object> data) {
        this.taskId = taskId;
        this.userId = userId;
        this.data = data;
    }

    public Void execute(Context cntxt) {
        boolean ownerAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskFailedEvent>(){}}).fire((Object)task);
        boolean bl = ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!ownerAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.InProgress)) {
            task.getTaskData().setStatus(Status.Failed);
        }
        if (this.data != null) {
            FaultDataImpl faultData = ContentMarshallerHelper.marshalFault(this.data, null);
            ContentImpl content = new ContentImpl();
            content.setContent(faultData.getContent());
            context.getPm().persist((Object)content);
            task.getTaskData().setFault(content.getId(), (FaultData)faultData);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskFailedEvent>(){}}).fire((Object)task);
        return null;
    }
}

