/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.deadlines;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.I18NText;
import org.kie.internal.task.api.model.OrganizationalEntity;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.kie.internal.task.api.model.Task;

@Decorator
public class DeadlinesDecorator
implements TaskInstanceService {
    @Delegate
    @Inject
    private TaskInstanceService instanceService;
    @Inject
    private TaskQueryService queryService;
    @Inject
    private TaskDeadlinesService deadlineService;
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setInstanceService(TaskInstanceService instanceService) {
        this.instanceService = instanceService;
    }

    public void setQueryService(TaskQueryService queryService) {
        this.queryService = queryService;
    }

    public void setDeadlineService(TaskDeadlinesService deadlineService) {
        this.deadlineService = deadlineService;
    }

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public long addTask(Task task, Map<String, Object> params) {
        long taskId = this.instanceService.addTask(task, params);
        this.scheduleDeadlinesForTask(task);
        return taskId;
    }

    public long addTask(Task task, ContentData data) {
        long taskId = this.instanceService.addTask(task, data);
        this.scheduleDeadlinesForTask(task);
        return taskId;
    }

    public void activate(long taskId, String userId) {
        this.instanceService.activate(taskId, userId);
    }

    public void claim(long taskId, String userId) {
        this.instanceService.claim(taskId, userId);
    }

    public void claim(long taskId, String userId, List<String> groupIds) {
        this.instanceService.claim(taskId, userId, groupIds);
    }

    public void claimNextAvailable(String userId, String language) {
        this.instanceService.claimNextAvailable(userId, language);
    }

    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        this.instanceService.claimNextAvailable(userId, groupIds, language);
    }

    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.clearDeadlines(taskId, true, true);
        this.instanceService.complete(taskId, userId, data);
    }

    public void delegate(long taskId, String userId, String targetUserId) {
        this.instanceService.delegate(taskId, userId, targetUserId);
    }

    public void deleteFault(long taskId, String userId) {
        this.instanceService.deleteFault(taskId, userId);
    }

    public void deleteOutput(long taskId, String userId) {
        this.instanceService.deleteOutput(taskId, userId);
    }

    public void exit(long taskId, String userId) {
        this.instanceService.exit(taskId, userId);
        this.clearDeadlines(taskId, true, true);
    }

    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.clearDeadlines(taskId, true, true);
        this.instanceService.fail(taskId, userId, faultData);
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.instanceService.forward(taskId, userId, targetEntityId);
    }

    public void release(long taskId, String userId) {
        this.instanceService.release(taskId, userId);
    }

    public void remove(long taskId, String userId) {
        this.instanceService.remove(taskId, userId);
    }

    public void resume(long taskId, String userId) {
        this.instanceService.resume(taskId, userId);
    }

    public void setFault(long taskId, String userId, FaultData fault) {
        this.instanceService.setFault(taskId, userId, fault);
    }

    public void setOutput(long taskId, String userId, Object outputContentData) {
        this.instanceService.setOutput(taskId, userId, outputContentData);
    }

    public void setPriority(long taskId, int priority) {
        this.instanceService.setPriority(taskId, priority);
    }

    public void skip(long taskId, String userId) {
        this.instanceService.skip(taskId, userId);
        this.clearDeadlines(taskId, true, true);
    }

    public void start(long taskId, String userId) {
        this.clearDeadlines(taskId, true, false);
        this.instanceService.start(taskId, userId);
    }

    public void stop(long taskId, String userId) {
        this.instanceService.stop(taskId, userId);
    }

    public void suspend(long taskId, String userId) {
        this.instanceService.suspend(taskId, userId);
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.instanceService.nominate(taskId, userId, potentialOwners);
    }

    private void scheduleDeadlinesForTask(Task task) {
        long now = System.currentTimeMillis();
        Deadlines deadlines = task.getDeadlines();
        if (deadlines != null) {
            List endDeadlines;
            List startDeadlines = deadlines.getStartDeadlines();
            if (startDeadlines != null) {
                this.scheduleDeadlines(startDeadlines, now, task.getId(), TaskDeadlinesService.DeadlineType.START);
            }
            if ((endDeadlines = deadlines.getEndDeadlines()) != null) {
                this.scheduleDeadlines(endDeadlines, now, task.getId(), TaskDeadlinesService.DeadlineType.END);
            }
        }
    }

    private void scheduleDeadlines(List<? extends Deadline> deadlines, long now, long taskId, TaskDeadlinesService.DeadlineType type) {
        for (Deadline deadline : deadlines) {
            if (deadline.isEscalated().booleanValue()) continue;
            Date date = deadline.getDate();
            this.deadlineService.schedule(taskId, deadline.getId(), date.getTime() - now, type);
        }
    }

    private void clearDeadlines(long taskId, boolean removeStart, boolean removeEnd) {
        Task task = this.queryService.getTaskInstanceById(taskId);
        if (task.getDeadlines() == null) {
            return;
        }
        Iterator it = null;
        if (removeStart && task.getDeadlines().getStartDeadlines() != null) {
            it = task.getDeadlines().getStartDeadlines().iterator();
            while (it.hasNext()) {
                this.deadlineService.unschedule(taskId, TaskDeadlinesService.DeadlineType.START);
                this.pm.remove(it.next());
                it.remove();
            }
        }
        if (removeEnd && task.getDeadlines().getEndDeadlines() != null) {
            it = task.getDeadlines().getEndDeadlines().iterator();
            while (it.hasNext()) {
                this.deadlineService.unschedule(taskId, TaskDeadlinesService.DeadlineType.END);
                this.pm.remove(it.next());
                it.remove();
            }
        }
    }

    public void setExpirationDate(long taskId, Date date) {
        this.instanceService.setExpirationDate(taskId, date);
    }

    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        this.instanceService.setDescriptions(taskId, descriptions);
    }

    public void setSkipable(long taskId, boolean skipable) {
        this.instanceService.setSkipable(taskId, skipable);
    }

    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        this.instanceService.setSubTaskStrategy(taskId, strategy);
    }

    public int getPriority(long taskId) {
        return this.instanceService.getPriority(taskId);
    }

    public Date getExpirationDate(long taskId) {
        return this.instanceService.getExpirationDate(taskId);
    }

    public List<I18NText> getDescriptions(long taskId) {
        return this.instanceService.getDescriptions(taskId);
    }

    public boolean isSkipable(long taskId) {
        return this.instanceService.isSkipable(taskId);
    }

    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        return this.instanceService.getSubTaskStrategy(taskId);
    }

    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        this.instanceService.setTaskNames(taskId, taskNames);
    }
}

