/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.internal.task.api.TaskAdminService;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.TaskSummary;

@Transactional
@ApplicationScoped
public class TaskAdminServiceImpl
implements TaskAdminService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public List<TaskSummary> getActiveTasks() {
        HashMap params = this.pm.addParametersToMap(new Object[]{"status", Arrays.asList(Status.InProgress), "language", "en-UK"});
        return (List)this.pm.queryWithParametersInTransaction("TasksByStatus", (Map)params);
    }

    public List<TaskSummary> getActiveTasks(Date since) {
        HashMap params = this.pm.addParametersToMap(new Object[]{"status", Arrays.asList(Status.InProgress), "language", "en-UK", "since", since});
        return (List)this.pm.queryWithParametersInTransaction("TasksByStatus", (Map)params);
    }

    public List<TaskSummary> getCompletedTasks() {
        HashMap params = this.pm.addParametersToMap(new Object[]{"status", Arrays.asList(Status.Completed), "language", "en-UK"});
        return (List)this.pm.queryWithParametersInTransaction("TasksByStatus", (Map)params);
    }

    public List<TaskSummary> getCompletedTasks(Date since) {
        HashMap params = this.pm.addParametersToMap(new Object[]{"status", Arrays.asList(Status.Completed), "language", "en-UK", "since", since});
        return (List)this.pm.queryWithParametersInTransaction("TasksByStatusSince", (Map)params);
    }

    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        HashMap params = this.pm.addParametersToMap(new Object[]{"status", Arrays.asList(Status.Completed), "language", "en-UK", "processInstanceId", processId});
        return (List)this.pm.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)params);
    }

    public int archiveTasks(List<TaskSummary> tasks) {
        int archivedTasks = 0;
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
            task.setArchived(true);
            this.pm.persist((Object)task);
            ++archivedTasks;
        }
        return archivedTasks;
    }

    public List<TaskSummary> getArchivedTasks() {
        HashMap params = this.pm.addParametersToMap(new Object[]{"language", "en-UK"});
        return (List)this.pm.queryWithParametersInTransaction("ArchivedTasks", (Map)params);
    }

    public int removeTasks(List<TaskSummary> tasks) {
        int removedTasks = 0;
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
            ContentImpl content = (ContentImpl)this.pm.find(ContentImpl.class, (Object)task.getTaskData().getDocumentContentId());
            if (task.isArchived().booleanValue()) {
                this.pm.remove((Object)task);
                if (content != null) {
                    this.pm.remove((Object)content);
                }
                ++removedTasks;
                continue;
            }
            System.out.println(" The Task cannot be removed if it wasn't archived first !!");
        }
        return removedTasks;
    }

    public int removeAllTasks() {
        List tasks = (List)this.pm.queryStringInTransaction("select t from TaskImpl t");
        int count = 0;
        for (TaskImpl t : tasks) {
            this.pm.remove((Object)t);
            ++count;
        }
        return count;
    }
}

