/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.executor.api.ExecutorQueryService;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.entities.STATUS;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;

@Transactional
public class ExecutorQueryServiceImpl
implements ExecutorQueryService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    public List<RequestInfo> getPendingRequests() {
        return (List)this.pm.queryWithParametersInTransaction("PendingRequests", (Map)this.pm.addParametersToMap(new Object[]{"now", new Date()}));
    }

    @Override
    public List<RequestInfo> getPendingRequestById(Long id) {
        return (List)this.pm.queryWithParametersInTransaction("PendingRequestById", (Map)this.pm.addParametersToMap(new Object[]{"id", id}));
    }

    @Override
    public RequestInfo getRequestById(Long id) {
        return (RequestInfo)this.pm.find(RequestInfo.class, (Object)id);
    }

    @Override
    public List<RequestInfo> getRunningRequests() {
        return (List)this.pm.queryInTransaction("RunningRequests");
    }

    @Override
    public List<RequestInfo> getQueuedRequests() {
        return (List)this.pm.queryInTransaction("QueuedRequests");
    }

    @Override
    public List<RequestInfo> getFutureQueuedRequests() {
        return (List)this.pm.queryWithParametersInTransaction("FutureQueuedRequests", (Map)this.pm.addParametersToMap(new Object[]{"now", new Date()}));
    }

    @Override
    public List<RequestInfo> getCompletedRequests() {
        return (List)this.pm.queryInTransaction("CompletedRequests");
    }

    @Override
    public List<RequestInfo> getInErrorRequests() {
        return (List)this.pm.queryInTransaction("InErrorRequests");
    }

    @Override
    public List<RequestInfo> getCancelledRequests() {
        return (List)this.pm.queryInTransaction("CancelledRequests");
    }

    @Override
    public List<ErrorInfo> getAllErrors() {
        return (List)this.pm.queryInTransaction("GetAllErrors");
    }

    @Override
    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        return (List)this.pm.queryWithParametersInTransaction("GetErrorsByRequestId", (Map)this.pm.addParametersToMap(new Object[]{"id", requestId}));
    }

    @Override
    public List<RequestInfo> getAllRequests() {
        return (List)this.pm.queryInTransaction("GetAllRequests");
    }

    @Override
    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return (List)this.pm.queryWithParametersInTransaction("GetRequestsByStatus", (Map)this.pm.addParametersToMap(new Object[]{"statuses", statuses}));
    }
}

