/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import org.drools.core.base.ValueType;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.time.Interval;
import org.kie.api.runtime.rule.Operator;

public class EvaluatorWrapper
implements Evaluator {
    private static final long serialVersionUID = 520L;
    private static final SelfReferenceClassFieldReader extractor = new SelfReferenceClassFieldReader(Object.class, "dummy");
    private Evaluator evaluator;
    private transient InternalWorkingMemory workingMemory;
    private Declaration leftBinding;
    private Declaration rightBinding;
    private InternalFactHandle leftHandle;
    private InternalFactHandle rightHandle;
    private InternalReadAccessor leftExtractor;
    private InternalReadAccessor rightExtractor;
    private boolean selfLeft;
    private boolean selfRight;

    public EvaluatorWrapper(Evaluator evaluator, Declaration leftBinding, Declaration rightBinding) {
        this.evaluator = evaluator;
        this.leftBinding = leftBinding;
        this.rightBinding = rightBinding;
        this.init();
    }

    private void init() {
        this.leftExtractor = this.leftBinding == null || this.leftBinding.isPatternDeclaration() ? extractor : this.leftBinding.getExtractor();
        this.rightExtractor = this.rightBinding == null || this.rightBinding.isPatternDeclaration() ? extractor : this.rightBinding.getExtractor();
        this.selfLeft = this.leftBinding == null || this.leftBinding.getIdentifier().equals("this");
        this.selfRight = this.rightBinding == null || this.rightBinding.getIdentifier().equals("this");
    }

    public boolean evaluate(Object left, Object right) {
        return this.evaluator.evaluate(this.workingMemory, this.leftExtractor, this.leftHandle, this.rightExtractor, this.rightHandle);
    }

    @Override
    public ValueType getValueType() {
        return this.evaluator.getValueType();
    }

    @Override
    public Operator getOperator() {
        return this.evaluator.getOperator();
    }

    @Override
    public ValueType getCoercedValueType() {
        return this.evaluator.getCoercedValueType();
    }

    @Override
    public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
        return this.evaluator.evaluate(workingMemory, extractor, factHandle, value);
    }

    @Override
    public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
        return this.evaluator.evaluate(workingMemory, leftExtractor, left, rightExtractor, right);
    }

    @Override
    public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
        return this.evaluator.evaluateCachedLeft(workingMemory, context, right);
    }

    @Override
    public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
        return this.evaluator.evaluateCachedRight(workingMemory, context, left);
    }

    @Override
    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    @Override
    public Interval getInterval() {
        return this.evaluator.getInterval();
    }

    public void loadHandles(InternalWorkingMemory workingMemory, InternalFactHandle[] handles, Object rightObject) {
        this.workingMemory = workingMemory;
        this.leftHandle = this.selfLeft ? (InternalFactHandle)workingMemory.getFactHandle(rightObject) : MVELCompilationUnit.getFactHandle(this.leftBinding, handles);
        this.rightHandle = this.selfRight ? (InternalFactHandle)workingMemory.getFactHandle(rightObject) : MVELCompilationUnit.getFactHandle(this.rightBinding, handles);
    }

    public String toString() {
        return this.evaluator.toString();
    }

    public static SelfReferenceClassFieldReader getExtractor() {
        return extractor;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public Declaration getLeftBinding() {
        return this.leftBinding;
    }

    public Declaration getRightBinding() {
        return this.rightBinding;
    }

    public InternalFactHandle getLeftHandle() {
        return this.leftHandle;
    }

    public InternalFactHandle getRightHandle() {
        return this.rightHandle;
    }

    public InternalReadAccessor getLeftExtractor() {
        return this.leftExtractor;
    }

    public InternalReadAccessor getRightExtractor() {
        return this.rightExtractor;
    }

    public boolean isSelfLeft() {
        return this.selfLeft;
    }

    public boolean isSelfRight() {
        return this.selfRight;
    }
}

