/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Entity;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.HierarchyEncoderImpl;
import org.kie.api.definition.type.FactField;

public class TraitRegistry
implements Externalizable {
    private Map<String, ClassDefinition> traits;
    private Map<String, ClassDefinition> traitables;
    private int codeSize = 0;
    private Map<String, Long> masks;
    private HierarchyEncoder<String> hierarchy = new HierarchyEncoderImpl<String>();

    public TraitRegistry() {
        TypeDeclaration thingType = new TypeDeclaration(Thing.class.getName());
        thingType.setKind(TypeDeclaration.Kind.TRAIT);
        thingType.setTypeClass(Thing.class);
        ClassDefinition def = new ClassDefinition();
        def.setClassName(thingType.getTypeClass().getName());
        def.setDefinedClass(Thing.class);
        this.addTrait(def);
        ClassDefinition individualDef = new ClassDefinition();
        individualDef.setClassName(Entity.class.getName());
        individualDef.setDefinedClass(Entity.class);
        individualDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName()});
        individualDef.setTraitable(true);
        this.addTraitable(individualDef);
    }

    public void merge(TraitRegistry other) {
        if (this.traits == null) {
            this.traits = new HashMap<String, ClassDefinition>();
        }
        if (other.traits != null) {
            this.traits.putAll(other.traits);
        }
        if (this.traitables == null) {
            this.traitables = new HashMap<String, ClassDefinition>();
        }
        if (other.traitables != null) {
            this.traitables.putAll(other.traitables);
        }
        if (this.masks == null) {
            this.masks = new HashMap<String, Long>();
        }
        if (other.masks != null) {
            this.masks.putAll(other.masks);
        }
        if (this.hierarchy == null || this.hierarchy.size() <= 1) {
            this.hierarchy = other.hierarchy;
        } else if (other.traits != null) {
            for (String traitName : other.traits.keySet()) {
                ClassDefinition trait = other.traits.get(traitName);
                this.hierarchy.encode(trait.getName(), Arrays.asList(trait.getInterfaces()));
            }
        }
    }

    public Map<String, ClassDefinition> getTraits() {
        return this.traits;
    }

    protected ClassDefinition getTrait(String key) {
        ClassDefinition traitDef;
        if (key.endsWith("_Trait__Extension")) {
            key = key.replace("_Trait__Extension", "");
        }
        ClassDefinition classDefinition = traitDef = this.traits != null ? this.traits.get(key) : null;
        if (traitDef == null) {
            // empty if block
        }
        return traitDef;
    }

    public Map<String, ClassDefinition> getTraitables() {
        return this.traitables;
    }

    protected ClassDefinition getTraitable(String key) {
        return this.traitables != null ? this.traitables.get(key) : null;
    }

    public void addTrait(ClassDefinition trait) {
        this.addTrait(trait.getClassName(), trait);
        this.hierarchy.encode(trait.getName(), Arrays.asList(trait.getInterfaces()));
    }

    public void addTrait(String className, ClassDefinition trait) {
        if (this.traits == null) {
            this.traits = new HashMap<String, ClassDefinition>();
        }
        this.traits.put(className, trait);
        this.hierarchy.encode(className, this.getTraitInterfaces(trait));
    }

    private Collection<String> getTraitInterfaces(ClassDefinition trait) {
        ArrayList<String> intfs = new ArrayList<String>();
        for (String s : trait.getInterfaces()) {
            if (!this.traits.containsKey(s)) continue;
            intfs.add(s);
        }
        return intfs;
    }

    public void addTraitable(ClassDefinition traitable) {
        if (this.traitables == null) {
            this.traitables = new HashMap<String, ClassDefinition>();
        }
        this.traitables.put(traitable.getClassName(), traitable);
    }

    public static boolean isSoftField(FieldDefinition field, int index, long mask) {
        return (mask & (long)(1 << index)) == 0L;
    }

    public long getFieldMask(String trait, String traitable) {
        String key;
        Long mask;
        if (this.masks == null) {
            this.masks = new HashMap<String, Long>();
        }
        if ((mask = this.masks.get(key = trait + traitable)) == null) {
            mask = this.bind(trait, traitable);
            this.masks.put(key, mask);
        }
        return mask;
    }

    private Long bind(String trait, String traitable) throws UnsupportedOperationException {
        ClassDefinition traitDef = this.getTrait(trait);
        if (traitDef == null) {
            throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : not a trait ");
        }
        ClassDefinition traitableDef = this.getTraitable(traitable);
        if (traitableDef == null) {
            throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : not a traitable ");
        }
        int j = 0;
        long bitmask = 0L;
        for (FactField field : traitDef.getFields()) {
            FieldDefinition fdef = (FieldDefinition)field;
            boolean isAliased = fdef.hasAlias();
            String alias = ((FieldDefinition)field).resolveAlias(traitableDef);
            FieldDefinition concreteField = traitableDef.getField(alias);
            Class<?> concreteType = concreteField != null ? concreteField.getType() : null;
            Class virtualType = field.getType();
            if (concreteType != null && concreteType.isAssignableFrom(virtualType)) {
                bitmask |= (long)(1 << j);
            }
            ++j;
        }
        return bitmask;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.traits);
        objectOutput.writeObject(this.traitables);
        objectOutput.writeObject(this.masks);
        objectOutput.writeObject(this.hierarchy);
        objectOutput.writeInt(this.codeSize);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.traits = (Map)objectInput.readObject();
        this.traitables = (Map)objectInput.readObject();
        this.masks = (Map)objectInput.readObject();
        this.hierarchy = (HierarchyEncoderImpl)objectInput.readObject();
        this.codeSize = objectInput.readInt();
    }

    public HierarchyEncoder getHierarchy() {
        return this.hierarchy;
    }
}

