/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Entry;
import org.drools.core.util.index.LeftTupleList;

public class BaseLeftTuple
implements Tuple,
Entry,
LeftTuple {
    private static final long serialVersionUID = 540L;
    private int index;
    private InternalFactHandle handle;
    private LeftTuple parent;
    private LeftTuple leftParent;
    private LeftTuple leftParentPrevious;
    private LeftTuple leftParentNext;
    private RightTuple rightParent;
    private LeftTuple rightParentPrevious;
    private LeftTuple rightParentNext;
    private LeftTuple firstChild;
    private LeftTuple lastChild;
    private LeftTupleSink sink;
    private PropagationContext propagationContext;
    protected LeftTupleList memory;
    protected Entry next;
    protected Entry previous;
    protected short stagedType;
    protected LeftTuple stagedNext;
    protected LeftTuple stagedPrevious;
    private Object object;
    private LeftTuple peer;

    public BaseLeftTuple() {
    }

    public BaseLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = factHandle;
        this.sink = sink;
        if (leftTupleMemoryEnabled) {
            this.handle.addLeftTupleInPosition(this);
        }
    }

    public BaseLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        this.handle = factHandle;
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple;
        this.sink = sink;
    }

    public BaseLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        this.index = leftTuple.getIndex();
        this.parent = leftTuple.getParent();
        this.handle = leftTuple.getHandle();
        this.propagationContext = pctx;
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            if (leftTuple.getLastChild() != null) {
                this.leftParentPrevious = leftTuple.getLastChild();
                this.leftParentPrevious.setLeftParentNext(this);
            } else {
                leftTuple.setFirstChild(this);
            }
            leftTuple.setLastChild(this);
        }
        this.sink = sink;
    }

    public BaseLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple;
        this.handle = rightTuple.getFactHandle();
        this.propagationContext = rightTuple.getPropagationContext();
        this.leftParent = leftTuple;
        if (leftTuple.getLastChild() != null) {
            this.leftParentPrevious = leftTuple.getLastChild();
            this.leftParentPrevious.setLeftParentNext(this);
        } else {
            leftTuple.setFirstChild(this);
        }
        leftTuple.setLastChild(this);
        this.rightParent = rightTuple;
        if (rightTuple.lastChild != null) {
            this.rightParentPrevious = rightTuple.lastChild;
            this.rightParentPrevious.setRightParentNext(this);
        } else {
            rightTuple.firstChild = this;
        }
        rightTuple.lastChild = this;
        this.sink = sink;
    }

    public BaseLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public BaseLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = rightTuple.getFactHandle();
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple;
        this.propagationContext = rightTuple.getPropagationContext();
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            this.rightParent = rightTuple;
            if (currentLeftChild == null) {
                if (leftTuple.getLastChild() != null) {
                    this.leftParentPrevious = leftTuple.getLastChild();
                    this.leftParentPrevious.setLeftParentNext(this);
                } else {
                    leftTuple.setFirstChild(this);
                }
                leftTuple.setLastChild(this);
            } else {
                this.leftParentNext = currentLeftChild;
                this.leftParentPrevious = currentLeftChild.getLeftParentPrevious();
                currentLeftChild.setLeftParentPrevious(this);
                if (this.leftParentPrevious == null) {
                    this.leftParent.setFirstChild(this);
                } else {
                    this.leftParentPrevious.setLeftParentNext(this);
                }
            }
            if (currentRightChild == null) {
                if (rightTuple.lastChild != null) {
                    this.rightParentPrevious = rightTuple.lastChild;
                    this.rightParentPrevious.setRightParentNext(this);
                } else {
                    rightTuple.firstChild = this;
                }
                rightTuple.lastChild = this;
            } else {
                this.rightParentNext = currentRightChild;
                this.rightParentPrevious = currentRightChild.getRightParentPrevious();
                currentRightChild.setRightParentPrevious(this);
                if (this.rightParentPrevious == null) {
                    this.rightParent.firstChild = this;
                } else {
                    this.rightParentPrevious.setRightParentNext(this);
                }
            }
        }
        this.sink = sink;
    }

    @Override
    public void reAdd() {
        this.handle.addLastLeftTuple(this);
    }

    @Override
    public void reAddLeft() {
        if (this.leftParentNext != null) {
            if (this.leftParentPrevious != null) {
                this.leftParentPrevious.setLeftParentNext(this.leftParentNext);
                this.leftParentNext.setLeftParentPrevious(this.leftParentPrevious);
            } else {
                if (this.leftParent.getFirstChild() == this) {
                    this.leftParent.setFirstChild(this.leftParentNext);
                }
                this.leftParentNext.setLeftParentPrevious(null);
            }
            this.leftParentPrevious = this.leftParent.getLastChild();
            this.leftParentPrevious.setLeftParentNext(this);
            this.leftParent.setLastChild(this);
            this.leftParentNext = null;
        }
    }

    @Override
    public void reAddRight() {
        if (this.rightParentNext != null) {
            if (this.rightParentPrevious != null) {
                this.rightParentPrevious.setRightParentNext(this.rightParentNext);
                this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
            } else {
                if (this.rightParent.firstChild == this) {
                    this.rightParent.firstChild = this.rightParentNext;
                }
                this.rightParentNext.setRightParentPrevious(null);
            }
            this.rightParentPrevious = this.rightParent.lastChild;
            this.rightParentPrevious.setRightParentNext(this);
            this.rightParent.lastChild = this;
            this.rightParentNext = null;
        }
    }

    @Override
    public void unlinkFromLeftParent() {
        LeftTuple previousParent = this.leftParentPrevious;
        LeftTuple nextParent = this.leftParentNext;
        if (previousParent != null && nextParent != null) {
            this.leftParentPrevious.setLeftParentNext(nextParent);
            this.leftParentNext.setLeftParentPrevious(previousParent);
        } else if (nextParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setFirstChild(nextParent);
            } else {
                this.handle.removeLeftTuple(this);
            }
            nextParent.setLeftParentPrevious(null);
        } else if (previousParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setLastChild(previousParent);
            } else {
                this.handle.removeLeftTuple(this);
            }
            previousParent.setLeftParentNext(null);
        } else if (this.leftParent != null) {
            this.leftParent.setFirstChild(null);
            this.leftParent.setLastChild(null);
        } else {
            this.handle.removeLeftTuple(this);
        }
        this.leftParent = null;
        this.leftParentPrevious = null;
        this.leftParentNext = null;
    }

    @Override
    public void unlinkFromRightParent() {
        if (this.rightParent == null) {
            return;
        }
        LeftTuple previousParent = this.rightParentPrevious;
        LeftTuple nextParent = this.rightParentNext;
        if (previousParent != null && nextParent != null) {
            this.rightParentPrevious.setRightParentNext(this.rightParentNext);
            this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
        } else if (nextParent != null) {
            this.rightParent.firstChild = nextParent;
            nextParent.setRightParentPrevious(null);
        } else if (previousParent != null) {
            this.rightParent.lastChild = previousParent;
            previousParent.setRightParentNext(null);
        } else {
            this.rightParent.firstChild = null;
            this.rightParent.lastChild = null;
        }
        this.rightParent = null;
        this.rightParentPrevious = null;
        this.rightParentNext = null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public LeftTupleSink getLeftTupleSink() {
        return this.sink;
    }

    @Override
    public void setLeftTupleSink(LeftTupleSink sink) {
        this.sink = sink;
    }

    @Override
    public LeftTuple getLeftParent() {
        return this.leftParent;
    }

    @Override
    public void setLeftParent(LeftTuple leftParent) {
        this.leftParent = leftParent;
    }

    @Override
    public LeftTuple getLeftParentPrevious() {
        return this.leftParentPrevious;
    }

    @Override
    public void setLeftParentPrevious(LeftTuple leftParentLeft) {
        this.leftParentPrevious = leftParentLeft;
    }

    @Override
    public LeftTuple getLeftParentNext() {
        return this.leftParentNext;
    }

    @Override
    public void setLeftParentNext(LeftTuple leftParentright) {
        this.leftParentNext = leftParentright;
    }

    @Override
    public RightTuple getRightParent() {
        return this.rightParent;
    }

    @Override
    public void setRightParent(RightTuple rightParent) {
        this.rightParent = rightParent;
    }

    @Override
    public LeftTuple getRightParentPrevious() {
        return this.rightParentPrevious;
    }

    @Override
    public void setRightParentPrevious(LeftTuple rightParentLeft) {
        this.rightParentPrevious = rightParentLeft;
    }

    @Override
    public LeftTuple getRightParentNext() {
        return this.rightParentNext;
    }

    @Override
    public void setRightParentNext(LeftTuple rightParentRight) {
        this.rightParentNext = rightParentRight;
    }

    @Override
    public InternalFactHandle get(int index) {
        LeftTuple entry;
        for (entry = this; entry != null && entry.getIndex() != index; entry = entry.getParent()) {
        }
        return entry == null ? null : entry.getHandle();
    }

    public void setFactHandle(InternalFactHandle handle) {
        this.handle = handle;
    }

    @Override
    public InternalFactHandle getLastHandle() {
        return this.handle;
    }

    @Override
    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getPattern().getOffset());
    }

    @Override
    public InternalFactHandle[] getFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[this.index + 1];
        int i = 0;
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            handles[i++] = entry.getHandle();
        }
        return handles;
    }

    @Override
    public InternalFactHandle[] toFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            handles[entry.getIndex()] = entry.getHandle();
        }
        return handles;
    }

    @Override
    public void clearBlocker() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlocker(RightTuple blocker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RightTuple getBlocker() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeftTuple getBlockedPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeftTuple getBlockedNext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlockedNext(LeftTuple blockerNext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object getObject() {
        return this.object;
    }

    @Override
    public final void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            buffer.append(entry.getHandle());
            if (entry.getParent() == null) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    @Override
    public boolean equals(LeftTuple other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.handle != other.getHandle()) {
            return false;
        }
        if (this.parent == null) {
            return other.getParent() == null;
        }
        return this.parent.equals(other.getParent());
    }

    public boolean equals(Object object) {
        if (object instanceof LeftTuple) {
            return this.equals((LeftTuple)object);
        }
        return false;
    }

    @Override
    public int size() {
        return this.index + 1;
    }

    @Override
    public InternalFactHandle getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(InternalFactHandle handle) {
        this.handle = handle;
    }

    @Override
    public LeftTuple getFirstChild() {
        return this.firstChild;
    }

    @Override
    public void setFirstChild(LeftTuple firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public LeftTuple getLastChild() {
        return this.lastChild;
    }

    @Override
    public void setLastChild(LeftTuple lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public LeftTupleSink getSink() {
        return this.sink;
    }

    @Override
    public void setSink(LeftTupleSink sink) {
        this.sink = sink;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setParent(LeftTuple parent) {
        this.parent = parent;
    }

    @Override
    public LeftTupleList getMemory() {
        return this.memory;
    }

    @Override
    public void setMemory(LeftTupleList memory) {
        this.memory = memory;
    }

    @Override
    public Entry getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(Entry previous) {
        this.previous = previous;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public Entry getNext() {
        return this.next;
    }

    @Override
    public short getStagedType() {
        return this.stagedType;
    }

    @Override
    public void setStagedType(short stagedType) {
        this.stagedType = stagedType;
    }

    @Override
    public LeftTuple getStagedNext() {
        return this.stagedNext;
    }

    @Override
    public void setStagedNext(LeftTuple stageNext) {
        this.stagedNext = stageNext;
    }

    @Override
    public LeftTuple getStagedPrevious() {
        return this.stagedPrevious;
    }

    @Override
    public void setStagePrevious(LeftTuple stagePrevious) {
        this.stagedPrevious = stagePrevious;
    }

    @Override
    public void clearStaged() {
        this.stagedType = 0;
        this.stagedNext = null;
        this.stagedPrevious = null;
    }

    @Override
    public LeftTuple getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(LeftTuple peer) {
        this.peer = peer;
    }

    @Override
    public LeftTuple getSubTuple(int elements) {
        LeftTuple entry = this;
        if (elements < this.size()) {
            int lastindex = elements - 1;
            while (entry.getIndex() != lastindex) {
                entry = entry.getParent();
            }
        }
        return entry;
    }

    @Override
    public Object[] toObjectArray() {
        Object[] objects = new Object[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            Object object;
            objects[entry.getIndex()] = object = entry.getLastHandle().getObject();
        }
        return objects;
    }

    @Override
    public LeftTuple getParent() {
        return this.parent;
    }

    @Override
    public LeftTuple getRootLeftTuple() {
        if (this.parent == null) {
            return this;
        }
        LeftTuple currentLt = this.parent;
        while (currentLt.getParent() != null) {
            currentLt = currentLt.getParent();
        }
        return currentLt;
    }

    @Override
    public String toTupleTree(int indent) {
        StringBuilder buf = new StringBuilder();
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        String istr = new String(spaces);
        buf.append(istr);
        buf.append(this.toExternalString());
        buf.append("\n");
        for (LeftTuple leftTuple = this.firstChild; leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            buf.append(leftTuple.toTupleTree(indent + 4));
        }
        return buf.toString();
    }

    protected String toExternalString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%08X", System.identityHashCode(this))).append(":");
        int[] ids = new int[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            ids[entry.getIndex()] = entry.getLastHandle().getId();
        }
        builder.append(Arrays.toString(ids)).append(" sink=").append(this.sink.getClass().getSimpleName()).append("(").append(this.sink.getId()).append(")");
        return builder.toString();
    }

    @Override
    public void increaseActivationCountForEvents() {
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            if (!entry.getLastHandle().isEvent()) continue;
            ((EventFactHandle)entry.getLastHandle()).increaseActivationsCount();
        }
    }

    @Override
    public void decreaseActivationCountForEvents() {
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            if (!entry.getLastHandle().isEvent()) continue;
            ((EventFactHandle)entry.getLastHandle()).decreaseActivationsCount();
        }
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.propagationContext;
    }

    @Override
    public void setPropagationContext(PropagationContext propagationContext) {
        this.propagationContext = propagationContext;
    }

    @Override
    public void clear() {
        this.previous = null;
        this.next = null;
        this.memory = null;
    }

    public void initPeer(BaseLeftTuple original, LeftTupleSink sink) {
        this.index = original.index;
        this.parent = original.parent;
        this.handle = original.handle;
        this.propagationContext = original.propagationContext;
        this.sink = sink;
    }
}

