/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNodeLeftTuple;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.RightTupleList;

public class ExistsNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    public ExistsNode() {
    }

    public ExistsNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        while (rightTuple != null) {
            if (this.constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (!useLeftMemory) break;
                rightTuple.addBlocked(leftTuple);
                break;
            }
            rightTuple = (RightTuple)it.next(rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
        if (leftTuple.getBlocker() != null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        } else if (useLeftMemory) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, it);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)it.next(leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                memory.getLeftTupleMemory().remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.isUnlinkingEnabled()) {
            ExistsNode.doDeleteRightTuple(rightTuple, workingMemory, memory);
            return;
        }
        RightTupleMemory rightTupleMemory = memory.getRightTupleMemory();
        boolean useComparisonIndex = rightTupleMemory.getIndexType().isComparison();
        FastIterator rightIt = rightTupleMemory.fastIterator();
        RightTuple rootBlocker = useComparisonIndex ? null : (RightTuple)rightIt.next(rightTuple);
        rightTupleMemory.remove(rightTuple);
        rightTuple.setMemory(null);
        if (rightTuple.getBlocked() == null) {
            return;
        }
        LeftTuple leftTuple = rightTuple.getBlocked();
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.setBlocker(null);
            leftTuple.setBlockedPrevious(null);
            leftTuple.setBlockedNext(null);
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            if (useComparisonIndex) {
                rootBlocker = this.getFirstRightTuple(leftTuple, rightTupleMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
            }
            RightTuple newBlocker = rootBlocker;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next(newBlocker);
            }
            if (leftTuple.getBlocker() == null) {
                memory.getLeftTupleMemory().add(leftTuple);
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            leftTuple = temp;
        }
        rightTuple.nullBlocked();
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
            memory.getLeftTupleMemory().remove(leftTuple);
        } else {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            blocker.removeBlocked(leftTuple);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple firstRightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            memory.getLeftTupleMemory().remove(leftTuple);
        } else if (rightMemory.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        if (blocker == null || !this.constraints.isAllowedCachedLeft(memory.getContext(), blocker.getFactHandle())) {
            if (blocker != null) {
                blocker.removeBlocked(leftTuple);
            }
            FastIterator it = memory.getRightTupleMemory().fastIterator();
            RightTuple newBlocker = firstRightTuple;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next(newBlocker);
            }
        }
        if (leftTuple.getBlocker() == null) {
            memory.getLeftTupleMemory().add(leftTuple);
            if (leftTuple.getFirstChild() != null) {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
        } else if (leftTuple.getFirstChild() == null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
        } else {
            this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, true);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
            memory.getRightTupleMemory().removeAdd(rightTuple);
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple firstLeftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, leftIt);
        LeftTuple firstBlocked = rightTuple.getBlocked();
        rightTuple.nullBlocked();
        LeftTuple leftTuple = firstLeftTuple;
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                leftMemory.remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        RightTupleMemory rightTupleMemory = memory.getRightTupleMemory();
        if (firstBlocked != null) {
            boolean useComparisonIndex = rightTupleMemory.getIndexType().isComparison();
            FastIterator rightIt = this.getRightIterator(rightTupleMemory);
            RightTuple rootBlocker = useComparisonIndex ? null : (RightTuple)rightIt.next(rightTuple);
            RightTupleList list = rightTuple.getMemory();
            rightTupleMemory.removeAdd(rightTuple);
            if (!useComparisonIndex && rootBlocker == null && list == rightTuple.getMemory()) {
                rootBlocker = rightTuple;
            }
            LeftTuple leftTuple2 = firstBlocked;
            while (leftTuple2 != null) {
                LeftTuple temp = leftTuple2.getBlockedNext();
                leftTuple2.setBlockedPrevious(null);
                leftTuple2.setBlockedNext(null);
                leftTuple2.setBlocker(null);
                this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple2);
                if (useComparisonIndex) {
                    rootBlocker = this.getFirstRightTuple(leftTuple2, rightTupleMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
                }
                RightTuple newBlocker = rootBlocker;
                while (newBlocker != null) {
                    if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                        leftTuple2.setBlocker(newBlocker);
                        newBlocker.addBlocked(leftTuple2);
                        break;
                    }
                    newBlocker = (RightTuple)rightIt.next(newBlocker);
                }
                if (leftTuple2.getBlocker() == null) {
                    memory.getLeftTupleMemory().add(leftTuple2);
                    this.sink.propagateRetractLeftTuple(leftTuple2, context, workingMemory);
                }
                leftTuple2 = temp;
            }
        } else {
            rightTupleMemory.removeAdd(rightTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            for (LeftTuple leftTuple = rightTuple.getBlocked(); leftTuple != null; leftTuple = leftTuple.getBlockedNext()) {
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, sink, context, true), context, workingMemory);
            }
            rightTuple = (RightTuple)it.next();
        }
    }

    @Override
    public String toString() {
        ObjectSource source = this.rightInput;
        while (source != null && source.getClass() != ObjectTypeNode.class) {
            source = source.source;
        }
        return "[ExistsNode(" + this.getId() + ") - " + (source != null ? ((ObjectTypeNode)source).getObjectType() : "<source from a subnetwork>") + "]";
    }

    @Override
    public short getType() {
        return 201;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        NotNodeLeftTuple peer = new NotNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }
}

