/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.core.util.CodedHierarchy;

public class CodedHierarchyImpl<T>
implements CodedHierarchy<T>,
Externalizable {
    protected SortedMap<BitSet, HierNode<T>> line = new TreeMap<BitSet, HierNode<T>>(new HierCodeComparator());
    protected boolean fixedRoot = false;

    @Override
    public int size() {
        return this.fixedRoot ? this.line.size() - 1 : this.line.size();
    }

    @Override
    public boolean hasKey(BitSet key) {
        return this.line.containsKey(key);
    }

    protected HierNode<T> getNodeByKey(BitSet key) {
        return (HierNode)this.line.get(key);
    }

    protected HierNode<T> getNode(T name) {
        for (HierNode<T> node : this.getNodes()) {
            if (node.getValue() == null || !node.getValue().equals(name)) continue;
            return node;
        }
        return null;
    }

    protected void add(HierNode<T> node) {
        this.line.put(node.getBitMask(), node);
    }

    protected void remove(HierNode<T> node) {
        this.line.remove(node.getBitMask());
    }

    protected boolean contains(HierNode<T> node) {
        return this.line.containsKey(node.getBitMask());
    }

    protected Collection<HierNode<T>> getNodes() {
        return this.line.values();
    }

    @Override
    public BitSet getCode(T val) {
        if (val == null) {
            return null;
        }
        HierNode<T> node = this.getNode(val);
        return node != null ? node.getBitMask() : null;
    }

    @Override
    public BitSet metMembersCode(Collection<T> vals) {
        BitSet x = new BitSet();
        for (T val : vals) {
            x.or(this.getNode(val).getBitMask());
        }
        return x;
    }

    @Override
    public BitSet jointMembersCode(Collection<T> vals) {
        BitSet x = new BitSet();
        boolean first = true;
        for (T val : vals) {
            if (first) {
                first = false;
                x.or(this.getNode(val).getBitMask());
                continue;
            }
            x.and(this.getNode(val).getBitMask());
        }
        return x;
    }

    @Override
    public BitSet meetCode(Collection<BitSet> codes) {
        BitSet x = new BitSet();
        for (BitSet code : codes) {
            x.or(code);
        }
        return x;
    }

    @Override
    public BitSet joinCode(Collection<BitSet> codes) {
        BitSet x = new BitSet();
        boolean first = true;
        for (BitSet code : codes) {
            if (first) {
                first = false;
                x.or(code);
                continue;
            }
            x.and(code);
        }
        return x;
    }

    @Override
    public List<T> getSortedMembers() {
        ArrayList<T> anx = new ArrayList<T>(this.size());
        for (HierNode<T> node : this.getNodes()) {
            if (node.getValue() == null) continue;
            anx.add(node.getValue());
        }
        return anx;
    }

    @Override
    public Map<T, BitSet> getSortedMap() {
        LinkedHashMap<T, BitSet> anx = new LinkedHashMap<T, BitSet>(this.size());
        for (HierNode<T> node : this.getNodes()) {
            if (node.getValue() == null) continue;
            anx.put(node.getValue(), node.getBitMask());
        }
        return anx;
    }

    @Override
    public T getMember(BitSet key) {
        return this.line.containsKey(key) ? (T)((HierNode)this.line.get(key)).getValue() : null;
    }

    @Override
    public void addMember(T val, BitSet key) {
        if (this.hasKey(key)) {
            HierNode node = (HierNode)this.line.get(key);
            node.setValue(val);
        } else {
            HierNode<T> node = new HierNode<T>(val, key);
            List<HierNode<T>> infs = this.gcsBorderNodes(key, false);
            List<HierNode<T>> sups = this.lcsBorderNodes(key, false);
            for (HierNode hierNode : infs) {
                if (hierNode == null) continue;
                hierNode.getParents().add(node);
                hierNode.getParents().removeAll(sups);
                node.getChildren().add(hierNode);
            }
            for (HierNode hierNode : sups) {
                if (hierNode == null) continue;
                hierNode.getChildren().add(node);
                hierNode.getChildren().removeAll(infs);
                node.getParents().add(hierNode);
            }
            this.add(node);
        }
    }

    @Override
    public void removeMember(T val) {
        if (val == null) {
            return;
        }
        BitSet key = this.getCode(val);
        this.removeMember(key);
    }

    @Override
    public void removeMember(BitSet key) {
        if (!this.hasKey(key)) {
            return;
        }
        HierNode<T> node = this.getNodeByKey(key);
        Collection<HierNode<T>> children = node.getChildren();
        Collection<HierNode<T>> parents = node.getParents();
        for (HierNode<T> child : children) {
            child.getParents().remove(node);
            child.getParents().addAll(parents);
        }
        for (HierNode<T> parent : parents) {
            parent.getChildren().remove(node);
            parent.getChildren().addAll(children);
        }
        this.remove(node);
    }

    protected Collection<T> parentValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> p = new ArrayList<T>(node.getParents().size());
        for (HierNode<T> parent : node.getParents()) {
            p.add(parent.getValue());
        }
        return p;
    }

    @Override
    public Collection<T> parents(T x) {
        HierNode<T> node = this.getNode(x);
        return this.parentValues(node);
    }

    @Override
    public Collection<T> parents(BitSet x) {
        HierNode<T> node = this.getNodeByKey(x);
        return this.parentValues(node);
    }

    @Override
    public Collection<T> ancestors(T x) {
        HierNode<T> node = this.getNode(x);
        return this.ancestorValues(node);
    }

    @Override
    public Collection<T> ancestors(BitSet key) {
        HierNode<T> node = this.getNodeByKey(key);
        return this.ancestorValues(node);
    }

    protected Collection<T> ancestorValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<T> ancestors = new HashSet<T>();
        Collection<HierNode<T>> parents = node.getParents();
        for (HierNode<T> p : parents) {
            ancestors.add(p.getValue());
            ancestors.addAll(this.ancestors(p.getValue()));
        }
        return ancestors;
    }

    protected Set<HierNode<T>> ancestorNodes(HierNode<T> x) {
        HashSet<HierNode<T>> ancestors = new HashSet<HierNode<T>>();
        Collection<HierNode<T>> parents = x.getParents();
        ancestors.addAll(parents);
        for (HierNode<T> p : parents) {
            ancestors.addAll(this.ancestorNodes(p));
        }
        return ancestors;
    }

    @Override
    public Collection<T> upperAncestors(BitSet key) {
        LinkedList<T> vals = new LinkedList<T>();
        BitSet start = new BitSet();
        BitSet end = new BitSet();
        int index = 0;
        T rootVal = this.getMember(new BitSet());
        if (rootVal != null) {
            vals.add(rootVal);
        }
        while (index >= 0) {
            int s = index;
            int t = key.nextClearBit(s);
            start.clear();
            start.set(s, true);
            end.set(s, t, true);
            if (t > 0) {
                for (HierNode<T> val : this.line.subMap(start, this.nextKey(end)).values()) {
                    vals.add(val.getValue());
                }
            }
            index = key.nextSetBit(t);
        }
        return vals;
    }

    protected Collection<T> childrenValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> c = new ArrayList<T>(node.getChildren().size());
        for (HierNode<T> child : node.getChildren()) {
            c.add(child.getValue());
        }
        return c;
    }

    @Override
    public Collection<T> children(T x) {
        HierNode<T> node = this.getNode(x);
        return this.childrenValues(node);
    }

    @Override
    public Collection<T> children(BitSet key) {
        HierNode<T> node = this.getNodeByKey(key);
        return this.childrenValues(node);
    }

    protected Collection<T> descendantValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<T> descendants = new HashSet<T>();
        descendants.add(node.getValue());
        Collection<HierNode<T>> children = node.getChildren();
        for (HierNode<T> c : children) {
            descendants.add(c.getValue());
            descendants.addAll(this.descendants(c.getValue()));
        }
        return descendants;
    }

    @Override
    public Collection<T> descendants(T y) {
        HierNode<T> node = this.getNode(y);
        return this.descendantValues(node);
    }

    @Override
    public Collection<T> descendants(BitSet key) {
        HierNode<T> node = this.getNodeByKey(key);
        return this.descendantValues(node);
    }

    protected Set<HierNode<T>> descendantNodes(HierNode<T> y) {
        HashSet<HierNode<T>> descendants = new HashSet<HierNode<T>>();
        descendants.add(y);
        Collection<HierNode<T>> children = y.getChildren();
        descendants.addAll(children);
        for (HierNode<T> c : children) {
            descendants.addAll(this.descendantNodes(c));
        }
        return descendants;
    }

    @Override
    public Collection<T> lowerDescendants(BitSet key) {
        LinkedList<T> vals = new LinkedList<T>();
        if (key.length() == 0) {
            return new ArrayList<T>(this.getSortedMembers());
        }
        int n = this.line.lastKey().length();
        for (int j = key.length(); j <= n; ++j) {
            BitSet start = new BitSet();
            start.or(key);
            start.set(j - 1);
            BitSet end = new BitSet();
            end.set(j);
            for (HierNode<T> val : this.line.subMap(start, end).values()) {
                BitSet x = val.getBitMask();
                if (this.superset(x, key) < 0) continue;
                vals.add(val.getValue());
            }
        }
        return vals;
    }

    @Override
    public Collection<T> lowerBorder(BitSet key) {
        return this.gcs(key, true);
    }

    @Override
    public Collection<T> immediateChildren(BitSet key) {
        return this.gcs(key, false);
    }

    Collection<T> gcs(BitSet key, boolean includeEquals) {
        LinkedList<T> vals = new LinkedList<T>();
        List<HierNode<T>> border = this.gcsBorderNodes(key, includeEquals);
        for (int j = 0; j < border.size(); ++j) {
            HierNode<T> node = border.get(j);
            if (node == null) continue;
            vals.add(node.getValue());
        }
        return vals;
    }

    List<HierNode<T>> gcsBorderNodes(BitSet key, boolean includeEquals) {
        LinkedList<HierNode<T>> border = new LinkedList<HierNode<T>>();
        int n = this.line.size() != 0 ? this.line.lastKey().length() : 0;
        for (int j = key.length(); j <= n; ++j) {
            BitSet start = new BitSet();
            start.or(key);
            if (j > 0) {
                start.set(j - 1);
            }
            BitSet end = new BitSet();
            end.set(j);
            for (HierNode<T> val : this.line.subMap(start, end).values()) {
                BitSet candidate = val.getBitMask();
                boolean minimal = true;
                int check = this.superset(candidate, key);
                if ((!includeEquals || check < 0) && (includeEquals || check <= 0)) continue;
                for (int k = 0; k < border.size(); ++k) {
                    HierNode ex = (HierNode)border.get(k);
                    if (ex == null) continue;
                    if (this.superset(candidate, ex.getBitMask()) >= 0) {
                        minimal = false;
                        break;
                    }
                    if (this.superset(ex.getBitMask(), candidate) <= 0) continue;
                    border.set(k, null);
                }
                if (!minimal) continue;
                border.add(val);
            }
        }
        return border;
    }

    @Override
    public Collection<T> upperBorder(BitSet key) {
        return this.lcs(key, true);
    }

    @Override
    public Collection<T> immediateParents(BitSet key) {
        return this.lcs(key, false);
    }

    Collection<T> lcs(BitSet key, boolean includeEquals) {
        LinkedList<T> vals = new LinkedList<T>();
        List<HierNode<T>> border = this.lcsBorderNodes(key, includeEquals);
        for (int j = 0; j < border.size(); ++j) {
            HierNode<T> node = border.get(j);
            if (node == null) continue;
            vals.add(node.getValue());
        }
        return vals;
    }

    List<HierNode<T>> lcsBorderNodes(BitSet key, boolean includeEquals) {
        ArrayList<HierNode<T>> border = new ArrayList<HierNode<T>>();
        BitSet start = new BitSet();
        BitSet end = new BitSet();
        int index = 0;
        HierNode root = (HierNode)this.line.get(new BitSet());
        if (root != null) {
            border.add(root);
        }
        while (index >= 0) {
            int s = index;
            int t = key.nextClearBit(s);
            start.clear();
            start.set(s, true);
            end.set(s, t, true);
            for (HierNode<T> val : this.line.subMap(start, this.nextKey(end)).values()) {
                BitSet candidate = val.getBitMask();
                int comp = this.superset(key, candidate);
                if ((!includeEquals || comp < 0) && (includeEquals || comp <= 0)) continue;
                border.add(val);
                for (int j = 0; j < border.size(); ++j) {
                    HierNode ex = (HierNode)border.get(j);
                    if (ex == null || this.superset(candidate, ex.getBitMask()) <= 0) continue;
                    border.set(j, null);
                }
            }
            index = key.nextSetBit(t);
        }
        return border;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("*****************************************\n");
        int len = 0;
        for (HierNode<T> node : this.getNodes()) {
            len = Math.max(len, this.numBit(node.getBitMask()));
        }
        for (HierNode<T> node : this.getNodes()) {
            builder.append(node.toString(len)).append("\n");
        }
        builder.append("*****************************************\n");
        builder.append(this.getSortedMap()).append("\n");
        builder.append("*****************************************\n");
        return builder.toString();
    }

    protected String toBinaryString(BitSet mask) {
        return this.toBinaryString(mask, mask.length());
    }

    protected String toBinaryString(BitSet mask, int len) {
        StringBuilder sb = new StringBuilder();
        for (int j = len - 1; j >= 0; --j) {
            sb.append(mask.get(j) ? "1 " : "0 ");
        }
        return sb.toString();
    }

    BitSet prevKey(BitSet key) {
        BitSet b = new BitSet();
        b.or(key);
        int x = key.nextSetBit(0);
        if (x == 0) {
            b.clear(0);
        } else {
            b.set(0, x, true);
            b.clear(x);
        }
        return b;
    }

    BitSet nextKey(BitSet key) {
        BitSet b = new BitSet();
        b.or(key);
        int x = key.nextSetBit(0);
        if (x == 0) {
            int y = b.nextClearBit(0);
            b.set(x, y, false);
            b.set(y);
        } else {
            b.set(0);
        }
        return b;
    }

    public static boolean supersetOrEqualset(BitSet n1, BitSet n2) {
        BitSet x = new BitSet();
        x.or(n1);
        x.and(n2);
        return x.equals(n2);
    }

    int superset(HierNode<T> n1, HierNode<T> n2) {
        return this.superset(n1.getBitMask(), n2.getBitMask());
    }

    int superset(BitSet n1, BitSet n2) {
        if (n1.equals(n2)) {
            return 0;
        }
        return CodedHierarchyImpl.supersetOrEqualset(n1, n2) ? 1 : -1;
    }

    int numBit(BitSet x) {
        return x.length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.line);
        objectOutput.writeBoolean(this.fixedRoot);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.line = (SortedMap)objectInput.readObject();
        this.fixedRoot = objectInput.readBoolean();
    }

    public static BitSet stringToBitSet(String s) {
        BitSet b = new BitSet();
        int n = s.length();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) == '1') {
                b.set(n - j - 1);
                continue;
            }
            if (s.charAt(j) == '0') continue;
            throw new IllegalStateException("The string " + s + " is not a valid bitset encoding");
        }
        return b;
    }

    protected static class HierCodeComparator
    implements Comparator<BitSet>,
    Externalizable {
        @Override
        public int compare(BitSet bitMask, BitSet yset) {
            int l;
            for (int j = l = (lx = bitMask.length()) > (ly = yset.length()) ? lx : ly; j >= 0; --j) {
                boolean x = bitMask.get(j);
                boolean y = yset.get(j);
                if (x && !y) {
                    return 1;
                }
                if (!y || x) continue;
                return -1;
            }
            return 0;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        }
    }

    protected static class HierNode<T>
    implements Comparable<HierNode<T>>,
    Externalizable {
        public T value;
        public BitSet bitMask = null;
        public List<HierNode<T>> parents = new ArrayList<HierNode<T>>();
        public List<HierNode<T>> children = new ArrayList<HierNode<T>>();

        public HierNode() {
        }

        public HierNode(T value) {
            this.value = value;
        }

        protected HierNode(HierNode<T> xt) {
            this.value = xt.getValue();
            this.bitMask = xt.getBitMask();
            this.parents.addAll(xt.getParents());
            this.children.addAll(xt.getChildren());
        }

        public HierNode(BitSet key) {
            this.bitMask = key;
        }

        public HierNode(T val, BitSet key) {
            this.value = val;
            this.bitMask = key;
        }

        public T getValue() {
            return this.value;
        }

        public BitSet getBitMask() {
            return this.bitMask;
        }

        public void setBitMask(BitSet bitMask) {
            if (this.bitMask == null) {
                this.bitMask = bitMask;
            } else {
                this.bitMask.clear();
                this.bitMask.or(bitMask);
            }
        }

        public Collection<HierNode<T>> getParents() {
            return this.parents;
        }

        public Collection<HierNode<T>> getChildren() {
            return this.children;
        }

        public void addChild(HierNode<T> node) {
            this.children.add(node);
        }

        public void addParent(HierNode<T> node) {
            this.parents.add(node);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierNode hierNode = (HierNode)o;
            return this.bitMask.equals(hierNode.bitMask);
        }

        public int hashCode() {
            return this.bitMask.hashCode();
        }

        public String toString() {
            return this.toString(this.bitMask != null ? this.bitMask.length() : 0);
        }

        public String toString(int len) {
            return this.value + "[ " + (this.bitMask != null ? this.toBinaryString(this.bitMask, len) : "n/a") + "]";
        }

        protected String toBinaryString(BitSet mask, int len) {
            StringBuilder sb = new StringBuilder();
            for (int j = len - 1; j >= 0; --j) {
                sb.append(mask.get(j) ? "1 " : "0 ");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(HierNode<T> hierNode) {
            int l;
            BitSet yset = hierNode.bitMask;
            for (int j = l = (lx = this.bitMask.length()) > (ly = yset.length()) ? lx : ly; j >= 0; --j) {
                boolean x = this.bitMask.get(j);
                boolean y = yset.get(j);
                if (x && !y) {
                    return 1;
                }
                if (!y || x) continue;
                return -1;
            }
            return 0;
        }

        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.value);
            out.writeObject(this.bitMask);
            out.writeObject(this.parents);
            out.writeObject(this.children);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readObject();
            this.bitMask = (BitSet)in.readObject();
            this.parents = (List)in.readObject();
            this.children = (List)in.readObject();
        }
    }
}

