/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.AbstractHTWorkItemHandler;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.entity.TaskCompletedEvent;
import org.jbpm.task.event.entity.TaskEvent;
import org.jbpm.task.event.entity.TaskFailedEvent;
import org.jbpm.task.event.entity.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericHTWorkItemHandler.class);
    private TaskService client;
    private String ipAddress;
    private int port;
    private boolean local = false;
    private boolean connected = false;
    private ClassLoader classLoader;
    private boolean owningSessionOnly = false;

    public GenericHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action) {
        super(session, action);
    }

    public GenericHTWorkItemHandler(TaskService client, KnowledgeRuntime session, OnErrorAction action) {
        super(session, action);
        this.client = client;
    }

    public GenericHTWorkItemHandler(TaskService client, KnowledgeRuntime session, OnErrorAction action, ClassLoader classLoader) {
        super(session, action);
        this.client = client;
        this.classLoader = classLoader;
    }

    public GenericHTWorkItemHandler(TaskService client, KnowledgeRuntime session) {
        super(session);
        this.client = client;
    }

    public GenericHTWorkItemHandler(TaskService client, KnowledgeRuntime session, boolean owningSessionOnly) {
        super(session);
        this.client = client;
        this.owningSessionOnly = owningSessionOnly;
    }

    public GenericHTWorkItemHandler(KnowledgeRuntime session) {
        super(session);
    }

    public GenericHTWorkItemHandler(KnowledgeRuntime session, boolean owningSessionOnly) {
        super(session);
    }

    public TaskService getClient() {
        return this.client;
    }

    public void setClient(TaskService client) {
        this.client = client;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getPort() {
        return this.port;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void registerTaskEvents() {
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
    }

    public void connect() {
        if (this.client == null) {
            throw new IllegalStateException("You must set the Task Service Client to the work item to work");
        }
        if (this.ipAddress == null || this.ipAddress.equals("") || this.port <= 0) {
            throw new IllegalStateException("You must set the IP and Port to the work item to work");
        }
        if (this.client != null && !this.connected) {
            this.connected = this.client.connect(this.ipAddress, this.port);
            if (!this.connected) {
                throw new IllegalArgumentException("Could not connect task client: on ip: " + this.ipAddress + " - port: " + this.port);
            }
            this.registerTaskEvents();
        }
    }

    public void dispose() throws Exception {
        for (TaskEventKey key : this.eventHandlers.keySet()) {
            this.client.unregisterForEvent(key);
        }
        this.eventHandlers.clear();
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block6: {
            Task task = this.createTaskBasedOnWorkItemParams(workItem);
            ContentData content = this.createTaskContentBasedOnWorkItemParams(workItem);
            this.connect();
            try {
                this.client.addTask(task, content);
                if (this.isAutoClaim(workItem, task)) {
                    this.autoClaim(workItem.getId(), (String)workItem.getParameter("SwimlaneActorId"));
                }
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    manager.abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block6;
                StringBuffer logMsg = new StringBuffer();
                logMsg.append(new Date() + ": Error when creating task on task server for work item id " + workItem.getId());
                logMsg.append(". Error reported by task server: " + e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Task task = this.client.getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                this.client.exit(task.getId(), "Administrator");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }

    public void autoClaim(long workItemId, String claimUser) {
        Task task = this.client.getTaskByWorkItemId(workItemId);
        if (task != null) {
            try {
                this.client.claim(task.getId(), claimUser);
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }

    public boolean isOwningSessionOnly() {
        return this.owningSessionOnly;
    }

    public void setOwningSessionOnly(boolean owningSessionOnly) {
        this.owningSessionOnly = owningSessionOnly;
    }

    private class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private TaskCompletedHandler() {
        }

        @Override
        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            final long taskId = event.getTaskId();
            if (GenericHTWorkItemHandler.this.owningSessionOnly && GenericHTWorkItemHandler.this.session instanceof StatefulKnowledgeSession && ((StatefulKnowledgeSession)GenericHTWorkItemHandler.this.session).getId() != event.getSessionId()) {
                return;
            }
            if (GenericHTWorkItemHandler.this.local) {
                this.handleCompletedTask(taskId);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TaskCompletedHandler.this.handleCompletedTask(taskId);
                    }
                };
                new Thread(runnable).start();
            }
        }

        @Override
        public boolean isRemove() {
            return false;
        }

        public void handleCompletedTask(long taskId) {
            Task task = GenericHTWorkItemHandler.this.client.getTask(taskId);
            long workItemId = task.getTaskData().getWorkItemId();
            Status taskStatus = task.getTaskData().getStatus();
            if (taskStatus == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    Content content = GenericHTWorkItemHandler.this.client.getContent(contentId);
                    Object result = ContentMarshallerHelper.unmarshall(content.getContent(), GenericHTWorkItemHandler.this.session.getEnvironment(), GenericHTWorkItemHandler.this.classLoader);
                    results.put("Result", result);
                    if (result instanceof Map) {
                        Map map = (Map)result;
                        for (Map.Entry entry : map.entrySet()) {
                            if (!(entry.getKey() instanceof String)) continue;
                            results.put((String)entry.getKey(), entry.getValue());
                        }
                    }
                    GenericHTWorkItemHandler.this.session.getWorkItemManager().completeWorkItem(task.getTaskData().getWorkItemId(), results);
                } else {
                    GenericHTWorkItemHandler.this.session.getWorkItemManager().completeWorkItem(workItemId, results);
                }
            } else {
                if (taskStatus == Status.Created || taskStatus == Status.Ready || taskStatus == Status.Reserved || taskStatus == Status.InProgress) {
                    throw new RuntimeException("Invalid status received with completed task event " + (Object)((Object)taskStatus));
                }
                GenericHTWorkItemHandler.this.session.getWorkItemManager().abortWorkItem(workItemId);
            }
        }
    }
}

