/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.admin;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.event.DefaultProcessEventListener;
import org.jbpm.task.Status;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskService;
import org.kie.api.event.process.ProcessCompletedEvent;

public class TaskCleanUpProcessEventListener
extends DefaultProcessEventListener {
    private TaskService taskService;

    public TaskCleanUpProcessEventListener(TaskService taskService) {
        this.taskService = taskService;
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        TasksAdmin admin = this.taskService.createTaskAdmin();
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Error);
        statuses.add(Status.Failed);
        statuses.add(Status.Obsolete);
        statuses.add(Status.Suspended);
        statuses.add(Status.Completed);
        statuses.add(Status.Exited);
        List<TaskSummary> completedTasksByProcessId = admin.getTasksByProcessId(event.getProcessInstance().getId(), statuses);
        admin.archiveTasks(completedTasksByProcessId);
        admin.removeTasks(completedTasksByProcessId);
        admin.dispose();
    }
}

