/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.admin;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksAdminImpl
implements TasksAdmin {
    protected TaskPersistenceManager tpm;
    private static final Logger logger = LoggerFactory.getLogger(TaskServiceSession.class);

    public TasksAdminImpl(TaskPersistenceManager tpm) {
        this.tpm = tpm;
    }

    @Override
    public List<TaskSummary> getActiveTasks() {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", Arrays.asList(Status.InProgress), "language", "en-UK");
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatus", params);
    }

    @Override
    public List<TaskSummary> getActiveTasks(Date since) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", Arrays.asList(Status.InProgress), "language", "en-UK", "since", since);
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatus", params);
    }

    @Override
    public List<TaskSummary> getCompletedTasks() {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", Arrays.asList(Status.Completed), "language", "en-UK");
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatus", params);
    }

    @Override
    public List<TaskSummary> getCompletedTasks(Date since) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", Arrays.asList(Status.Completed), "language", "en-UK", "since", since);
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatusSince", params);
    }

    @Override
    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", Arrays.asList(Status.Completed), "language", "en-UK", "processInstanceId", processId);
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatusByProcessId", params);
    }

    @Override
    public int archiveTasks(List<TaskSummary> tasks) {
        int archivedTasks = 0;
        boolean txOwner = this.tpm.beginTransaction();
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            Task task = (Task)this.tpm.findEntity(Task.class, taskId);
            task.setArchived(true);
            this.tpm.saveEntity(task);
            ++archivedTasks;
        }
        this.tpm.endTransaction(txOwner);
        return archivedTasks;
    }

    @Override
    public int removeTasks(List<TaskSummary> tasks) {
        int removedTasks = 0;
        boolean txOwner = this.tpm.beginTransaction();
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            Task task = (Task)this.tpm.findEntity(Task.class, taskId);
            Content content = (Content)this.tpm.findEntity(Content.class, task.getTaskData().getDocumentContentId());
            if (task.isArchived().booleanValue()) {
                this.tpm.deleteEntity(task);
                if (content != null) {
                    this.tpm.deleteEntity(content);
                }
                ++removedTasks;
                continue;
            }
            logger.error(" The Task cannot be removed if it wasn't archived first !!");
        }
        this.tpm.endTransaction(txOwner);
        return removedTasks;
    }

    @Override
    public List<TaskSummary> getArchivedTasks() {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("language", "en-UK");
        return (List)this.tpm.queryWithParametersInTransaction("ArchivedTasks", params);
    }

    @Override
    public void dispose() {
        this.tpm.endPersistenceContext();
    }

    @Override
    public List<TaskSummary> getTasks(List<Status> statuses) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", statuses, "language", "en-UK");
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatus", params);
    }

    @Override
    public List<TaskSummary> getTasks(Date since, List<Status> statuses) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", statuses, "language", "en-UK", "since", since);
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatusSince", params);
    }

    @Override
    public List<TaskSummary> getTasksByProcessId(Long processId, List<Status> statuses) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("status", statuses, "language", "en-UK", "processInstanceId", processId);
        return (List)this.tpm.queryWithParametersInTransaction("TasksByStatusByProcessId", params);
    }
}

