/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventKeys;
import org.jbpm.eventmessaging.EventTriggerTransport;
import org.jbpm.task.event.EventPayload;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.TaskEventListener;
import org.jbpm.task.event.entity.TaskClaimedEvent;
import org.jbpm.task.event.entity.TaskCompletedEvent;
import org.jbpm.task.event.entity.TaskCreatedEvent;
import org.jbpm.task.event.entity.TaskEvent;
import org.jbpm.task.event.entity.TaskFailedEvent;
import org.jbpm.task.event.entity.TaskForwardedEvent;
import org.jbpm.task.event.entity.TaskReleasedEvent;
import org.jbpm.task.event.entity.TaskSkippedEvent;
import org.jbpm.task.event.entity.TaskStartedEvent;
import org.jbpm.task.event.entity.TaskStoppedEvent;
import org.jbpm.task.event.entity.TaskUserEvent;

public class MessagingTaskEventListener
implements TaskEventListener {
    private EventKeys keys;

    public MessagingTaskEventListener(EventKeys keys) {
        this.keys = keys;
    }

    private List<EventTriggerTransport> getTargets(EventKey key, EventKey generalKey) {
        List<EventTriggerTransport> targets = this.keys.getTargets(key);
        if (targets == null) {
            targets = this.keys.getTargets(generalKey);
            if (targets == null) {
                return null;
            }
            targets = new ArrayList<EventTriggerTransport>(targets);
        } else {
            targets = new ArrayList<EventTriggerTransport>(targets);
            List<EventTriggerTransport> additionalTargets = this.keys.getTargets(generalKey);
            if (additionalTargets != null) {
                targets.addAll(additionalTargets);
            }
        }
        return targets;
    }

    private void triggerPayload(TaskEvent event, List<EventTriggerTransport> targets) {
        EventPayload payload = new EventPayload(event);
        Iterator<EventTriggerTransport> it = targets.iterator();
        while (it.hasNext()) {
            EventTriggerTransport target = it.next();
            target.trigger(payload);
            if (!target.isRemove()) continue;
            it.remove();
        }
    }

    private void handleEvent(Class<? extends TaskEvent> taskEventClass, TaskUserEvent event) {
        TaskEventKey generalKey;
        TaskEventKey key = new TaskEventKey(taskEventClass, event.getTaskId());
        List<EventTriggerTransport> targets = this.getTargets(key, generalKey = new TaskEventKey(taskEventClass, -1L));
        if (targets == null) {
            return;
        }
        this.triggerPayload(event, targets);
        if (targets.isEmpty()) {
            this.keys.removeKey(key);
        }
    }

    @Override
    public void taskClaimed(TaskUserEvent event) {
        this.handleEvent(TaskClaimedEvent.class, event);
    }

    @Override
    public void taskCompleted(TaskUserEvent event) {
        this.handleEvent(TaskCompletedEvent.class, event);
    }

    @Override
    public void taskFailed(TaskUserEvent event) {
        this.handleEvent(TaskFailedEvent.class, event);
    }

    @Override
    public void taskSkipped(TaskUserEvent event) {
        this.handleEvent(TaskSkippedEvent.class, event);
    }

    @Override
    public void taskCreated(TaskUserEvent event) {
        this.handleEvent(TaskCreatedEvent.class, event);
    }

    @Override
    public void taskStarted(TaskUserEvent event) {
        this.handleEvent(TaskStartedEvent.class, event);
    }

    @Override
    public void taskStopped(TaskUserEvent event) {
        this.handleEvent(TaskStoppedEvent.class, event);
    }

    @Override
    public void taskReleased(TaskUserEvent event) {
        this.handleEvent(TaskReleasedEvent.class, event);
    }

    @Override
    public void taskForwarded(TaskUserEvent event) {
        this.handleEvent(TaskForwardedEvent.class, event);
    }
}

