/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.task.event.entity.TaskEventType;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
@SequenceGenerator(name="taskEventIdSeq", sequenceName="TASK_EVENT_ID_SEQ", allocationSize=1)
public abstract class TaskEvent
implements Externalizable {
    @Column(insertable=false, updatable=false)
    private String type;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="taskEventIdSeq")
    private Long id;
    @Column(nullable=false)
    protected Long taskId;
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date eventTime = new Date();
    @Column(nullable=true)
    protected String userId;
    @Column(nullable=true)
    protected int sessionId;

    public TaskEvent() {
    }

    public TaskEvent(long taskId, int sessionId) {
        this.taskId = taskId;
        this.sessionId = sessionId;
    }

    public TaskEvent(long taskId, String userId, int sessionId) {
        this.taskId = taskId;
        this.userId = userId;
        this.sessionId = sessionId;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.taskId != null ? this.taskId : -1L);
        out.writeLong(this.id != null ? this.id : -1L);
        out.writeLong(this.eventTime != null ? this.eventTime.getTime() : -1L);
        int version = 0;
        out.writeShort(version);
        out.writeInt(this.sessionId);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long readLong = in.readLong();
        this.taskId = readLong > -1L ? new Long(readLong) : null;
        readLong = in.readLong();
        this.id = readLong > -1L ? new Long(readLong) : null;
        readLong = in.readLong();
        this.eventTime = readLong > -1L ? new Date(readLong) : null;
        short version = in.readShort();
        this.sessionId = in.readInt();
    }

    public long getTaskId() {
        return this.taskId;
    }

    public Long getId() {
        return this.id;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getType() {
        return this.type;
    }

    public TaskEventType getTaskEventType() {
        return TaskEventType.getTypeFromValue(this.type);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }
}

